/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.php.launching;

import java.io.File;
import java.util.HashMap;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugLineBreakpoint;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStackFrame;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugThread;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugVariable;
import net.sourceforge.phpeclipse.xdebug.ui.XDebugUIPluginImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PHPDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    protected HashMap fAttributes = new HashMap(3);

    public String getEditorId(IEditorInput input, Object inputObject) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        this.fAttributes.put(id, value);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof LocalFileStorage) {
            LocalFileStorage lfc = (LocalFileStorage)element;
            return new StorageEditorInput((IStorage)lfc, lfc.getFile());
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof XDebugLineBreakpoint) {
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
        }
        if (element instanceof IMarker) {
            if (((IMarker)element).getAttribute("org.eclipse.debug.core.enabled", false)) {
                return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
        }
        if (element instanceof XDebugStackFrame || element instanceof XDebugThread || element instanceof XDebugTarget) {
            return this.getDebugElementImage(element);
        }
        if (element instanceof XDebugVariable) {
            return this.getVariableImage((XDebugVariable)element);
        }
        if (element instanceof XDebugValue) {
            return this.getValueImage((XDebugValue)element);
        }
        return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
    }

    private Image getVariableImage(XDebugVariable phpVar) {
        if (phpVar.getVisibility().equals("protected")) {
            return XDebugUIPluginImages.get("IMG_FIELD_PROTECTED");
        }
        if (phpVar.getVisibility().equals("private")) {
            return XDebugUIPluginImages.get("IMG_FIELD_PRIVATE");
        }
        return XDebugUIPluginImages.get("IMG_FIELD_PUBLIC");
    }

    private Image getValueImage(XDebugValue phpVar) {
        if (phpVar != null) {
            return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
        }
        return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
    }

    public String getText(Object element) {
        try {
            if (element instanceof XDebugLineBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element);
            }
            if (element instanceof XDebugVariable) {
                XDebugVariable phpVar = (XDebugVariable)element;
                return String.valueOf(phpVar.getName()) + "= " + phpVar.getValueString();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getBreakpointText(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof XDebugLineBreakpoint) {
            return this.getLineBreakpointText((XDebugLineBreakpoint)breakpoint);
        }
        return "";
    }

    protected String getLineBreakpointText(XDebugLineBreakpoint breakpoint) throws CoreException {
        StringBuffer label = new StringBuffer();
        label.append(breakpoint.getMarker().getResource().getFullPath());
        label.append(" [");
        label.append(' ');
        label.append(breakpoint.getLineNumber());
        label.append(']');
        return label.toString();
    }

    protected Image getDebugElementImage(Object element) {
        Image image = null;
        if (element instanceof XDebugThread) {
            XDebugThread thread = (XDebugThread)element;
            image = thread.isSuspended() ? DebugUITools.getImage((String)"IMG_OBJS_THREAD_SUSPENDED") : (thread.isTerminated() ? DebugUITools.getImage((String)"IMG_OBJS_THREAD_TERMINATED") : DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING"));
        } else if (element instanceof XDebugStackFrame) {
            image = DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME");
        } else if (element instanceof XDebugTarget) {
            XDebugTarget debugTarget = (XDebugTarget)element;
            image = debugTarget.isTerminated() ? DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED") : DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
        }
        return image;
    }

    class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput {
        private File fFile;
        private IStorage fStorage;

        public StorageEditorInput(IStorage storage, File file) {
            this.fStorage = storage;
            this.fFile = file;
        }

        public IStorage getStorage() {
            return this.fStorage;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.getStorage().getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.getStorage().getFullPath().toOSString();
        }

        public boolean equals(Object object) {
            return object instanceof StorageEditorInput && this.getStorage().equals(((StorageEditorInput)((Object)object)).getStorage());
        }

        public int hashCode() {
            return this.getStorage().hashCode();
        }

        public boolean exists() {
            return this.fFile.exists();
        }
    }
}

