/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui;

import net.sourceforge.phpdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditPathMapDialog
extends StatusDialog {
    private Text fLocalPathText;
    private Text fRemotePathText;
    private String[] fInitialValues;
    private String fLocalPath;
    private String fRemotePath;

    public EditPathMapDialog(Shell parentShell, String aDialogTitle, String[] initialValues) {
        super(parentShell);
        this.setTitle(aDialogTitle);
        this.fInitialValues = initialValues;
    }

    protected void okPressed() {
        this.fLocalPath = this.fLocalPathText.getText();
        this.fRemotePath = this.fRemotePathText.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite composite) {
        Composite comp = new Composite(composite, 0);
        comp.setLayout((Layout)new GridLayout());
        Composite fileComp = new Composite(comp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        fileComp.setLayout((Layout)gridLayout);
        Label label = new Label(fileComp, 0);
        label.setText("Local_Path");
        this.fLocalPathText = new Text(fileComp, 2052);
        GridData gd = new GridData();
        gd.widthHint = 250;
        this.fLocalPathText.setLayoutData((Object)gd);
        this.fLocalPathText.setText(this.fInitialValues[0]);
        Button button = new Button(fileComp, 8);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPathMapDialog.this.handleBrowseButtonSelected();
            }
        });
        label = new Label(fileComp, 0);
        label.setText("Remote Path");
        this.fRemotePathText = new Text(fileComp, 2052);
        this.fRemotePathText.setText(this.fInitialValues[1]);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fRemotePathText.setLayoutData((Object)gd);
        return composite;
    }

    public String[] getPathPair() {
        return new String[]{this.fLocalPath, this.fRemotePath};
    }

    private void handleBrowseButtonSelected() {
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setMessage("Select the directory to map");
        String path = dd.open();
        if (path != null) {
            this.fLocalPathText.setText(path);
        }
    }
}

