/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import net.sourceforge.phpeclipse.webbrowser.internal.ImageResource;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BusyIndicator
extends Canvas {
    protected Image[] images = ImageResource.getBusyImages();
    protected Image image;
    protected Thread busyThread;
    protected boolean stop;

    public BusyIndicator(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BusyIndicator.this.onPaint(event);
            }
        });
        this.image = this.images[0];
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(25, 25);
    }

    protected synchronized void createBusyThread() {
        if (this.busyThread != null) {
            return;
        }
        this.stop = false;
        this.busyThread = new Thread(){
            protected int count;

            public void run() {
                try {
                    this.count = 1;
                    while (!BusyIndicator.this.stop) {
                        Display.getDefault().syncExec(new Runnable(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (!2.access$0(this.this$1).stop) {
                                    if (this.this$1.count < 13) {
                                        2.access$0(this.this$1).setImage(2.access$0(this.this$1).images[this.this$1.count]);
                                    }
                                    ++this.this$1.count;
                                    if (this.this$1.count > 12) {
                                        this.this$1.count = 1;
                                    }
                                }
                            }
                        });
                        try {
                            2.sleep(125L);
                        }
                        catch (Exception exception) {}
                    }
                    if (BusyIndicator.this.busyThread == null) {
                        Display.getDefault().syncExec((Runnable)new Thread(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                2.access$0(this.this$1).setImage(2.access$0(this.this$1).images[0]);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Busy error", e);
                }
            }

            static /* synthetic */ BusyIndicator access$0(2 var0) {
                return var0.BusyIndicator.this;
            }
        };
        this.busyThread.setPriority(7);
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }

    public void dispose() {
        this.stop = true;
        this.busyThread = null;
        super.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busyThread != null;
    }

    protected void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        if (this.image != null) {
            gc.drawImage(this.image, 2, 2);
        }
    }

    public synchronized void setBusy(boolean busy) {
        if (busy) {
            if (this.busyThread == null) {
                this.createBusyThread();
            }
        } else if (this.busyThread != null) {
            this.stop = true;
            this.busyThread = null;
        }
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }
}

