/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.variable;

import net.sourceforge.phpdt.externaltools.variable.ExpandVariableContext;
import net.sourceforge.phpdt.externaltools.variable.IVariableLocationExpander;
import net.sourceforge.phpdt.externaltools.variable.IVariableResourceExpander;
import net.sourceforge.phpdt.externaltools.variable.IVariableTextExpander;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ResourceExpander
implements IVariableLocationExpander,
IVariableResourceExpander,
IVariableTextExpander {
    IResource expand(String varValue, ExpandVariableContext context) {
        if (varValue != null && varValue.length() > 0) {
            return this.expandToMember(varValue);
        }
        return this.expandUsingContext(context);
    }

    IResource expandUsingContext(ExpandVariableContext context) {
        return context.getSelectedResource();
    }

    IResource expandToMember(String varValue) {
        return this.getWorkspaceRoot().findMember(varValue);
    }

    public IPath getPath(String varTag, String varValue, ExpandVariableContext context) {
        IResource resource = this.expand(varValue, context);
        if (resource != null) {
            if (this.isPathVariable(varTag)) {
                return resource.getFullPath();
            }
            return resource.getLocation();
        }
        return null;
    }

    private boolean isPathVariable(String varTag) {
        return varTag.equals("container_path") || varTag.equals("project_path") || varTag.equals("resource_path");
    }

    public IResource[] getResources(String varTag, String varValue, ExpandVariableContext context) {
        IResource resource = this.expand(varValue, context);
        if (resource != null) {
            return new IResource[]{resource};
        }
        return null;
    }

    protected final IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getText(String varTag, String varValue, ExpandVariableContext context) {
        IPath path = this.getPath(varTag, varValue, context);
        if (path != null) {
            return path.toString();
        }
        return null;
    }
}

