/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.core.jdom.IDOMNode;

/**
 * @see IField
 */

/* package */class SourceField extends Member implements IField {

	/**
	 * Constructs a handle to the field with the given name in the specified
	 * type.
	 */
	protected SourceField(JavaElement parent, String name) {
		super(parent, name);
	}

	public boolean equals(Object o) {
		if (!(o instanceof SourceField))
			return false;
		return super.equals(o);
	}

	/**
	 * @see JavaElement#equalsDOMNode
	 */
	protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
		return (node.getNodeType() == IDOMNode.FIELD)
				&& super.equalsDOMNode(node);
	}

	/**
	 * @see IField
	 */
	public Object getConstant() throws JavaModelException {
		SourceFieldElementInfo info = (SourceFieldElementInfo) getElementInfo();
		return info.initializationSource;
	}

	/**
	 * @see IJavaElement
	 */
	public int getElementType() {
		return FIELD;
	}

	/**
	 * @see JavaElement#getHandleMemento()
	 */
	protected char getHandleMementoDelimiter() {
		return JavaElement.JEM_FIELD;
	}

	/**
	 * @see IField
	 */
	public String getTypeSignature() throws JavaModelException {
		// SourceFieldElementInfo info = (SourceFieldElementInfo)
		// getElementInfo();
		// return info.getTypeSignature();
		return "";
	}

	/**
	 * @private Debugging purposes
	 */
	protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
		buffer.append(this.tabString(tab));
		if (info == null) {
			buffer.append(getElementName());
			buffer.append(" (not open)"); //$NON-NLS-1$
		} else if (info == NO_INFO) {
			buffer.append(getElementName());
		} else {
			try {
				buffer.append(Signature.toString(this.getTypeSignature()));
				buffer.append(" "); //$NON-NLS-1$
				buffer.append(this.getElementName());
			} catch (JavaModelException e) {
				buffer
						.append("<JavaModelException in toString of " + getElementName()); //$NON-NLS-1$
			}
		}
	}
}
