/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import net.sourceforge.phpeclipse.webbrowser.views.J5CharsetEmulator;
import net.sourceforge.phpeclipse.webbrowser.views.ShowInContextBrowser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart
implements IShowInTarget {
    public static final String ID_BROWSER = "net.sourceforge.phpeclipse.webbrowser.views";
    WebBrowser fInstance = null;
    String fUrl = null;

    public void createPartControl(Composite frame) {
        try {
            if (WebBrowserUtil.isInternalBrowserOperational()) {
                this.fInstance = new WebBrowser(frame, true, true);
                this.fInstance.getBrowser().addCloseWindowListener(new CloseWindowListener(){

                    public void close(WindowEvent event) {
                        BrowserView.this.getViewSite().getPage().hideView((IViewPart)BrowserView.this);
                    }
                });
            }
        }
        catch (Exception exception) {
            this.fInstance = null;
        }
    }

    public void setFocus() {
        if (this.fInstance != null) {
            this.fInstance.setFocus();
        }
    }

    public void dispose() {
        if (this.fInstance != null) {
            this.fInstance.dispose();
            this.fInstance = null;
        }
        super.dispose();
    }

    public String getUrl() {
        if (this.fInstance != null) {
            return this.fInstance.getURL();
        }
        return null;
    }

    public void setUrl(String url) {
        if (this.fInstance != null) {
            this.fUrl = url;
            this.fInstance.setURL(url);
        }
    }

    public void refresh() {
        if (this.fInstance != null) {
            this.fInstance.refresh();
        }
    }

    public void refresh(String url) {
        if (this.fInstance != null && url != null) {
            if (this.fUrl == null) {
                this.setUrl(url);
            } else {
                Browser browser = this.fInstance.getBrowser();
                if (browser != null) {
                    String browserUrl = browser.getUrl();
                    try {
                        browserUrl = URLDecoder.decode(browserUrl, J5CharsetEmulator.defaultCharset().name());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    if (!url.equals(browserUrl)) {
                        this.setUrl(url);
                    }
                }
            }
        }
    }

    public void addProgressListener(ProgressListener listener) {
        if (this.fInstance != null) {
            this.fInstance.addProgressListener(listener);
        }
    }

    public void addStatusTextListener(StatusTextListener listener) {
        if (this.fInstance != null) {
            this.fInstance.addStatusTextListener(listener);
        }
    }

    public void addTitleListener(TitleListener listener) {
        if (this.fInstance != null) {
            this.fInstance.addTitleListener(listener);
        }
    }

    public boolean show(ShowInContext context) {
        ShowInContextBrowser contextBrowser;
        String localhostURL;
        if (context instanceof ShowInContextBrowser && (localhostURL = (contextBrowser = (ShowInContextBrowser)context).getLocalhostUrl()) != null) {
            this.setUrl(localhostURL);
            return true;
        }
        return false;
    }
}

