/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.IURLMap;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import net.sourceforge.phpeclipse.webbrowser.internal.ExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.Favorite;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class WebBrowserUtil {
    private static List urlMaps;
    private static List lockedFavorites;
    private static List unlockedFavorites;
    private static final String BROWSER_PACKAGE_NAME = "org.eclipse.swt.browser.Browser";
    public static Boolean isInternalBrowserOperational;
    private static List defaultBrowsers2;

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("lin") >= 0;
    }

    public static void openError(String message) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Shell shell = d.getActiveShell();
        MessageDialog.openError((Shell)shell, (String)WebBrowserUIPlugin.getResource("%errorDialogTitle"), (String)message);
    }

    public static void openMessage(String message) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Shell shell = d.getActiveShell();
        MessageDialog.openInformation((Shell)shell, (String)WebBrowserUIPlugin.getResource("%searchingTaskName"), (String)message);
    }

    public static List getURLMaps() {
        if (urlMaps == null) {
            WebBrowserUtil.loadURLMaps();
        }
        return urlMaps;
    }

    private static void loadURLMaps() {
        Trace.trace(Trace.FINEST, "->- Loading .urlMap extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("net.sourceforge.phpeclipse.webbrowser", "urlMap");
        int size = cf.length;
        urlMaps = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                IURLMap mapper = (IURLMap)cf[i].createExecutableExtension("class");
                urlMaps.add(mapper);
                Trace.trace(Trace.FINEST, "  Loaded url map: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load url map: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.FINEST, "-<- Done loading .urlMap extension point -<-");
    }

    public static List getUnlockedFavorites() {
        if (unlockedFavorites == null) {
            WebBrowserUtil.loadFavorites();
        }
        return unlockedFavorites;
    }

    public static List getLockedFavorites() {
        if (lockedFavorites == null) {
            WebBrowserUtil.loadFavorites();
        }
        return lockedFavorites;
    }

    private static void loadFavorites() {
        Trace.trace(Trace.FINEST, "->- Loading .favorites extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("net.sourceforge.phpeclipse.webbrowser", "favorites");
        int size = cf.length;
        unlockedFavorites = new ArrayList(size);
        lockedFavorites = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                Favorite f = new Favorite(cf[i].getAttribute("name"), cf[i].getAttribute("url"));
                String locked = cf[i].getAttribute("locked");
                if (!"true".equals(locked)) {
                    unlockedFavorites.add(f);
                } else {
                    lockedFavorites.add(f);
                }
                Trace.trace(Trace.FINEST, "  Loaded favorite: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load favorite: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.FINEST, "-<- Done loading .favorites extension point -<-");
    }

    public static boolean canUseInternalWebBrowser() {
        try {
            Class<?> clazz = Class.forName(BROWSER_PACKAGE_NAME);
            if (clazz != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    public static boolean isInternalBrowserOperational() {
        if (isInternalBrowserOperational != null) {
            return isInternalBrowserOperational;
        }
        try {
            new Browser((Composite)new Shell(Display.getCurrent()), 0);
            isInternalBrowserOperational = new Boolean(true);
        }
        catch (Throwable t) {
            WebBrowserUIPlugin.getInstance().getLog().log((IStatus)new Status(2, "net.sourceforge.phpeclipse.webbrowser", 0, "Internal browser is not operational", t));
            isInternalBrowserOperational = new Boolean(false);
        }
        return isInternalBrowserOperational;
    }

    public static List getExternalBrowserPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iterator = BrowserManager.getInstance().getWebBrowsers().iterator();
        while (iterator.hasNext()) {
            IWebBrowser wb = (IWebBrowser)iterator.next();
            if (!(wb instanceof IExternalWebBrowser)) continue;
            IExternalWebBrowser ext = (IExternalWebBrowser)wb;
            paths.add(ext.getLocation().toLowerCase());
        }
        return paths;
    }

    public static void addFoundBrowsers(List list) {
        List paths = WebBrowserUtil.getExternalBrowserPaths();
        Iterator iterator = WebBrowserUtil.getDefaultBrowsers().iterator();
        while (iterator.hasNext()) {
            DefaultBrowser browser2 = (DefaultBrowser)iterator.next();
            if (browser2.locations == null) continue;
            int size = browser2.locations.length;
            int j = 0;
            while (j < size) {
                String location = browser2.locations[j];
                if (!paths.contains(location.toLowerCase())) {
                    try {
                        File f = new File(location);
                        if (f.exists()) {
                            ExternalWebBrowser browser = new ExternalWebBrowser();
                            browser.name = browser2.name;
                            browser.location = location;
                            browser.parameters = browser2.params;
                            list.add(browser);
                            BrowserManager.getInstance().addBrowser(browser);
                            j += size;
                        }
                    }
                    catch (Exception exception) {}
                }
                ++j;
            }
        }
    }

    public static IExternalWebBrowserWorkingCopy createExternalBrowser(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        String executable = file.getName();
        Iterator iterator = WebBrowserUtil.getDefaultBrowsers().iterator();
        while (iterator.hasNext()) {
            DefaultBrowser db = (DefaultBrowser)iterator.next();
            if (!executable.equals(db.executable)) continue;
            IExternalWebBrowserWorkingCopy browser = BrowserManager.getInstance().createExternalWebBrowser();
            browser.setName(db.name);
            browser.setLocation(file.getAbsolutePath());
            browser.setParameters(db.params);
            return browser;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static List getDefaultBrowsers() {
        if (defaultBrowsers2 != null) {
            return defaultBrowsers2;
        }
        Reader reader = null;
        defaultBrowsers2 = new ArrayList();
        try {
            try {
                URL url = WebBrowserUIPlugin.getInstance().getBundle().getEntry("defaultBrowsers.xml");
                URL url2 = Platform.resolve((URL)url);
                reader = new InputStreamReader(url2.openStream());
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] children = memento.getChildren("browser");
                if (children != null) {
                    int size = children.length;
                    int i = 0;
                    while (i < size) {
                        IMemento child = children[i];
                        String name = child.getString("name");
                        String executable = child.getString("executable");
                        String params = child.getString("params");
                        ArrayList<String> locations = new ArrayList<String>();
                        IMemento[] locat = child.getChildren("location");
                        if (locat != null) {
                            int size2 = locat.length;
                            int j = 0;
                            while (j < size2) {
                                locations.add(locat[j].getTextData());
                                ++j;
                            }
                        }
                        String[] loc = new String[locations.size()];
                        locations.toArray(loc);
                        DefaultBrowser db = new DefaultBrowser(name, executable, params, loc);
                        Trace.trace(Trace.CONFIG, "Default browser: " + db);
                        defaultBrowsers2.add(db);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error loading default browsers", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var15_20 = null;
        }
        try {}
        catch (Exception exception) {
            return defaultBrowsers2;
        }
        reader.close();
        return defaultBrowsers2;
    }

    static class DefaultBrowser {
        String name;
        String params;
        String executable;
        String[] locations;

        public DefaultBrowser(String name, String executable, String params, String[] locations) {
            if (name == null) {
                name = "<unknown>";
            } else if (name.startsWith("%")) {
                name = WebBrowserUIPlugin.getResource(name);
            }
            this.name = name;
            this.executable = executable;
            this.params = params;
            this.locations = locations;
        }

        public String toString() {
            String s = "Browser: " + this.name + ", " + this.executable + ", " + this.params + ", ";
            if (this.locations != null) {
                int size = this.locations.length;
                int i = 0;
                while (i < size) {
                    s = String.valueOf(s) + this.locations[i] + ";";
                    ++i;
                }
            }
            return s;
        }
    }
}

