/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.util.Iterator;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import net.sourceforge.phpeclipse.webbrowser.internal.SwitchDefaultBrowserAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class SwitchBrowserWorkbenchAction
implements IWorkbenchWindowPulldownDelegate2 {
    private Menu fMenu;
    protected boolean recreateMenu = false;

    public void dispose() {
        this.setMenu(null);
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    public void init(IWorkbenchWindow window) {
    }

    protected void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    protected void fillMenu(Menu menu) {
        IWebBrowser current = BrowserManager.getInstance().getCurrentWebBrowser();
        Iterator iterator = BrowserManager.getInstance().getWebBrowsers().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            IWebBrowser browser = (IWebBrowser)iterator.next();
            this.addToMenu(menu, (IAction)new SwitchDefaultBrowserAction(browser, browser.equals(current)), i++);
        }
    }

    private void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                SwitchBrowserWorkbenchAction.this.fillMenu(m);
                SwitchBrowserWorkbenchAction.this.recreateMenu = false;
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.initMenu();
        return this.fMenu;
    }
}

