/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.core.model;

import net.sourceforge.phpeclipse.core.model.ISourceReference;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class SourceReference
implements ISourceReference {
    private IDocument document;
    private IRegion sourceRegion;

    public SourceReference(IDocument document) {
        this(document, 0, 0);
    }

    public SourceReference(IDocument document, int offset) {
        this(document, offset, 0);
    }

    public SourceReference(IDocument document, int offset, int length) {
        this.document = document;
        this.sourceRegion = new Region(offset, length);
    }

    public String getSource() {
        try {
            return this.document.get(this.sourceRegion.getOffset(), this.sourceRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException("Model not synchronized with document");
        }
    }

    public IRegion getSourceRegion() {
        return this.sourceRegion;
    }

    public final void setSourceRegion(int offset, int length) {
        this.sourceRegion = new Region(offset, length);
    }

    public final void setSourceRegion(IRegion region) {
        this.setSourceRegion(region.getOffset(), region.getLength());
    }

    protected final IDocument getDocument() {
        return this.document;
    }
}

