/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.AnnotationType;
import net.sourceforge.phpeclipse.phpeditor.ICompilationUnitDocumentProvider;
import net.sourceforge.phpeclipse.phpeditor.IPainter;
import net.sourceforge.phpeclipse.phpeditor.IPositionManager;
import net.sourceforge.phpeclipse.phpeditor.IProblemAnnotation;
import net.sourceforge.phpeclipse.phpeditor.ProblemAnnotationIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;

public class ProblemPainter
implements IPainter,
PaintListener,
IAnnotationModelListener {
    private boolean fIsActive = false;
    private boolean fIsPainting = false;
    private boolean fIsSettingModel = false;
    private ITextEditor fTextEditor;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private IAnnotationModel fModel;
    private List fProblemPositions = new ArrayList();
    private Map fColorTable = new HashMap();
    private Set fAnnotationSet = new HashSet();

    public ProblemPainter(ITextEditor textEditor, ISourceViewer sourceViewer) {
        this.fTextEditor = textEditor;
        this.fSourceViewer = sourceViewer;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    private boolean hasProblems() {
        return !this.fProblemPositions.isEmpty();
    }

    private void enablePainting() {
        if (!this.fIsPainting && this.hasProblems()) {
            this.fIsPainting = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    private void disablePainting(boolean redraw) {
        if (this.fIsPainting) {
            this.fIsPainting = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw && this.hasProblems()) {
                this.handleDrawRequest(null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setModel(IAnnotationModel model) {
        if (this.fModel == model) return;
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this);
        }
        this.fModel = model;
        if (this.fModel == null) return;
        try {
            this.fIsSettingModel = true;
            this.fModel.addAnnotationModelListener((IAnnotationModelListener)this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fIsSettingModel = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fIsSettingModel = false;
            return;
        }
    }

    private void catchupWithModel() {
        if (this.fProblemPositions != null) {
            this.fProblemPositions.clear();
            if (this.fModel != null) {
                ProblemAnnotationIterator e = new ProblemAnnotationIterator(this.fModel, true);
                while (e.hasNext()) {
                    IProblemAnnotation pa = (IProblemAnnotation)e.next();
                    Annotation a = (Annotation)pa;
                    Color color = null;
                    AnnotationType type = pa.getAnnotationType();
                    if (this.fAnnotationSet.contains(type)) {
                        color = (Color)this.fColorTable.get(type);
                    }
                    if (color == null) continue;
                    ProblemPosition pp = new ProblemPosition();
                    pp.fPosition = this.fModel.getPosition(a);
                    pp.fColor = color;
                    pp.fMultiLine = true;
                    this.fProblemPositions.add(pp);
                }
            }
        }
    }

    private void updatePainting() {
        this.disablePainting(true);
        this.catchupWithModel();
        this.enablePainting();
    }

    public void modelChanged(IAnnotationModel model) {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            if (this.fIsSettingModel) {
                this.updatePainting();
            } else {
                Display d = this.fTextWidget.getDisplay();
                if (d != null) {
                    d.asyncExec(new Runnable(){

                        public void run() {
                            if (ProblemPainter.this.fTextWidget != null && !ProblemPainter.this.fTextWidget.isDisposed()) {
                                ProblemPainter.this.updatePainting();
                            }
                        }
                    });
                }
            }
        }
    }

    public void setColor(AnnotationType annotationType, Color color) {
        if (color != null) {
            this.fColorTable.put(annotationType, color);
        } else {
            this.fColorTable.remove(annotationType);
        }
    }

    public void paintAnnotations(AnnotationType annotationType, boolean paint) {
        if (paint) {
            this.fAnnotationSet.add(annotationType);
        } else {
            this.fAnnotationSet.remove(annotationType);
        }
    }

    public boolean isPaintingAnnotations() {
        return !this.fAnnotationSet.isEmpty();
    }

    public void dispose() {
        if (this.fColorTable != null) {
            this.fColorTable.clear();
        }
        this.fColorTable = null;
        if (this.fAnnotationSet != null) {
            this.fAnnotationSet.clear();
        }
        this.fAnnotationSet = null;
        this.fTextWidget = null;
        this.fModel = null;
        this.fProblemPositions = null;
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int top = this.fSourceViewer.getTopIndex();
            if (this.fTextWidget.getTopPixel() % this.fTextWidget.getLineHeight() != 0) {
                --top;
            }
            try {
                IDocument document = this.fSourceViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        int vOffset = this.getInclusiveTopIndexStartOffset();
        int vLength = this.fSourceViewer.getBottomIndexEndOffset() + 1;
        Iterator e = this.fProblemPositions.iterator();
        while (e.hasNext()) {
            ProblemPosition pp = (ProblemPosition)e.next();
            Position p = pp.fPosition;
            if (!p.overlapsWith(vOffset, vLength)) continue;
            if (!pp.fMultiLine) {
                IRegion widgetRange = this.getWidgetRange(p);
                if (widgetRange == null) continue;
                this.draw(gc, widgetRange.getOffset(), widgetRange.getLength(), pp.fColor);
                continue;
            }
            IDocument document = this.fSourceViewer.getDocument();
            try {
                int startLine = document.getLineOfOffset(p.getOffset());
                int lastInclusive = Math.max(p.getOffset(), p.getOffset() + p.getLength() - 1);
                int endLine = document.getLineOfOffset(lastInclusive);
                int i = startLine;
                while (i <= endLine) {
                    IRegion widgetRange;
                    IRegion line = document.getLineInformation(i);
                    int paintStart = Math.max(line.getOffset(), p.getOffset());
                    int paintEnd = Math.min(line.getOffset() + line.getLength(), p.getOffset() + p.getLength());
                    if (paintEnd > paintStart && (widgetRange = this.getWidgetRange(new Position(paintStart, paintEnd - paintStart))) != null) {
                        this.draw(gc, widgetRange.getOffset(), widgetRange.getLength(), pp.fColor);
                    }
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private IRegion getWidgetRange(Position p) {
        int length;
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fSourceViewer;
            return extension.modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength()));
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int offset = region.getOffset();
        if (p.overlapsWith(offset, length = region.getLength())) {
            int p1 = Math.max(offset, p.getOffset());
            int p2 = Math.min(offset + length, p.getOffset() + p.getLength());
            return new Region(p1 - offset, p2 - p1);
        }
        return null;
    }

    private int[] computePolyline(Point left, Point right, int height) {
        int peeks = (right.x - left.x) / 4;
        int leftX = left.x;
        int length = (2 * peeks + 1) * 2;
        if (length < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int bottom = left.y + height - 1;
        int top = bottom - 2;
        int i = 0;
        while (i < peeks) {
            int index = 4 * i;
            coordinates[index] = leftX + 4 * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left.x + 4 * peeks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    private void draw(GC gc, int offset, int length, Color color) {
        if (gc != null) {
            Point left = this.fTextWidget.getLocationAtOffset(offset);
            Point right = this.fTextWidget.getLocationAtOffset(offset + length);
            gc.setForeground(color);
            int[] polyline = this.computePolyline(left, right, gc.getFontMetrics().getHeight());
            gc.drawPolyline(polyline);
        } else {
            this.fTextWidget.redrawRange(offset, length, true);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.disablePainting(redraw);
            this.setModel(null);
            this.catchupWithModel();
        }
    }

    public void paint(int reason) {
        if (!this.fIsActive) {
            this.fIsActive = true;
            ICompilationUnitDocumentProvider provider = PHPeclipsePlugin.getDefault().getCompilationUnitDocumentProvider();
            this.setModel(provider.getAnnotationModel(this.fTextEditor.getEditorInput()));
        } else if (16 == reason || 8 == reason) {
            this.updatePainting();
        }
    }

    public void setPositionManager(IPositionManager manager) {
    }

    private static class ProblemPosition {
        Position fPosition;
        Color fColor;
        boolean fMultiLine;

        private ProblemPosition() {
        }
    }
}

