/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import net.sourceforge.phpdt.internal.ui.text.PHPPairMatcher;
import net.sourceforge.phpeclipse.phpeditor.IPainter;
import net.sourceforge.phpeclipse.phpeditor.IPositionManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public final class BracketPainter
implements IPainter,
PaintListener {
    private PHPPairMatcher fMatcher = new PHPPairMatcher(new char[]{'{', '}', '(', ')', '[', ']'});
    private Position fBracketPosition = new Position(0, 0);
    private int fAnchor;
    private boolean fIsActive = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private Color fColor;
    private IPositionManager fPositionManager;

    public BracketPainter(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    public void setHighlightColor(Color color) {
        this.fColor = color;
    }

    public void dispose() {
        if (this.fMatcher != null) {
            this.fMatcher.dispose();
            this.fMatcher = null;
        }
        this.fColor = null;
        this.fTextWidget = null;
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (this.fPositionManager != null) {
                this.fPositionManager.removeManagedPosition(this.fBracketPosition);
            }
            if (redraw) {
                this.handleDrawRequest(null);
            }
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        if (this.fBracketPosition.isDeleted) {
            return;
        }
        int offset = this.fBracketPosition.getOffset();
        int length = this.fBracketPosition.getLength();
        if (length < 1) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fSourceViewer;
            IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            IRegion region = this.fSourceViewer.getVisibleRegion();
            if (region.getOffset() > offset || region.getOffset() + region.getLength() < offset + length) {
                return;
            }
            offset -= region.getOffset();
        }
        if (this.fAnchor == 0) {
            this.draw(gc, offset, 1);
        } else {
            this.draw(gc, offset + length - 1, 1);
        }
    }

    private void draw(GC gc, int offset, int length) {
        if (gc != null) {
            Point left = this.fTextWidget.getLocationAtOffset(offset);
            Point right = this.fTextWidget.getLocationAtOffset(offset + length);
            gc.setForeground(this.fColor);
            gc.drawRectangle(left.x, left.y, right.x - left.x - 1, gc.getFontMetrics().getHeight() - 1);
        } else {
            this.fTextWidget.redrawRange(offset, length, true);
        }
    }

    public void paint(int reason) {
        Point selection = this.fSourceViewer.getSelectedRange();
        if (selection.y > 0) {
            this.deactivate(true);
            return;
        }
        IRegion pair = this.fMatcher.match(this.fSourceViewer.getDocument(), selection.x);
        if (pair == null) {
            this.deactivate(true);
            return;
        }
        if (this.fIsActive) {
            if (pair.getOffset() != this.fBracketPosition.getOffset() || pair.getLength() != this.fBracketPosition.getLength() || this.fMatcher.getAnchor() != this.fAnchor) {
                this.handleDrawRequest(null);
                this.fBracketPosition.isDeleted = false;
                this.fBracketPosition.offset = pair.getOffset();
                this.fBracketPosition.length = pair.getLength();
                this.fAnchor = this.fMatcher.getAnchor();
                this.handleDrawRequest(null);
            }
        } else {
            this.fIsActive = true;
            this.fBracketPosition.isDeleted = false;
            this.fBracketPosition.offset = pair.getOffset();
            this.fBracketPosition.length = pair.getLength();
            this.fAnchor = this.fMatcher.getAnchor();
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.fPositionManager.addManagedPosition(this.fBracketPosition);
            this.handleDrawRequest(null);
        }
    }

    public void setPositionManager(IPositionManager manager) {
        this.fPositionManager = manager;
    }
}

