/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import net.sourceforge.phpdt.internal.ui.actions.FoldingActionGroup;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import net.sourceforge.phpeclipse.phpeditor.PHPEditorMessages;
import net.sourceforge.phpeclipse.phpeditor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.GotoAnnotationAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class BasicJavaEditorActionContributor
extends BasicTextEditorActionContributor {
    private List fPartListeners = new ArrayList();
    private TogglePresentationAction fTogglePresentation;
    private GotoAnnotationAction fPreviousAnnotation;
    private GotoAnnotationAction fNextAnnotation;
    private RetargetTextEditorAction fGotoMatchingBracket;
    private RetargetTextEditorAction fGotoNextMemberAction;
    private RetargetTextEditorAction fGotoPreviousMemberAction;

    public BasicJavaEditorActionContributor() {
        ResourceBundle b = PHPEditorMessages.getResourceBundle();
        this.fTogglePresentation = new TogglePresentationAction();
        this.fPreviousAnnotation = new GotoAnnotationAction(b, "PreviousAnnotation.", null, false);
        this.fNextAnnotation = new GotoAnnotationAction(b, "NextAnnotation.", null, true);
        this.fGotoMatchingBracket = new RetargetTextEditorAction(b, "GotoMatchingBracket.");
        this.fGotoMatchingBracket.setActionDefinitionId("net.sourceforge.phpeclipse.ui.edit.text.php.goto.matching.bracket");
        this.fGotoNextMemberAction = new RetargetTextEditorAction(b, "GotoNextMember.");
        this.fGotoNextMemberAction.setActionDefinitionId("net.sourceforge.phpeclipse.ui.edit.text.php.goto.next.member");
        this.fGotoPreviousMemberAction = new RetargetTextEditorAction(b, "GotoPreviousMember.");
        this.fGotoPreviousMemberAction.setActionDefinitionId("net.sourceforge.phpeclipse.ui.edit.text.php.goto.previous.member");
    }

    protected final void markAsPartListener(RetargetAction action) {
        this.fPartListeners.add(action);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            page.addPartListener((IPartListener)((RetargetAction)e.next()));
        }
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator("group.open"));
            editMenu.add((IContributionItem)new Separator("group.generate"));
            editMenu.add((IContributionItem)new Separator("additions"));
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoPreviousMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        IActionBars actionBars = this.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fTogglePresentation.setEditor(textEditor);
        this.fPreviousAnnotation.setEditor(textEditor);
        this.fNextAnnotation.setEditor(textEditor);
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        if (part instanceof PHPEditor) {
            PHPEditor javaEditor = (PHPEditor)part;
            javaEditor.getActionGroup().fillActionBars(this.getActionBars());
            FoldingActionGroup foldingActions = javaEditor.getFoldingActionGroup();
            if (foldingActions != null) {
                foldingActions.updateActionBars();
            }
        }
    }

    public void dispose() {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            this.getPage().removePartListener((IPartListener)((RetargetAction)e.next()));
        }
        this.fPartListeners.clear();
        this.setActiveEditor(null);
        super.dispose();
    }
}

