/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator;

public class PHPIdentifier {
    public static final int CLASS = 1;
    public static final int FUNCTION = 2;
    public static final int VARIABLE = 3;
    public static final int METHOD = 4;
    public static final int DEFINE = 5;
    public static final int CONSTRUCTOR = 6;
    public static final int GLOBAL_VARIABLE = 7;
    public static final int EXTENDS = 8;
    public static final int IMPLEMENTS = 9;
    private String fIdentifier;
    private int fType;

    public PHPIdentifier(String identifier, int type) {
        this.fType = type;
        this.fIdentifier = identifier;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PHPIdentifier)) {
            return false;
        }
        return ((PHPIdentifier)obj).fType == this.fType && ((PHPIdentifier)obj).fIdentifier.equals(this.fIdentifier);
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public int getType() {
        return this.fType;
    }

    public boolean isClass() {
        return this.fType == 1;
    }

    public boolean isFunction() {
        return this.fType == 2;
    }

    public boolean isVariable() {
        return this.fType == 3;
    }

    public boolean isMethod() {
        return this.fType == 4;
    }

    public boolean isDefine() {
        return this.fType == 5;
    }

    public boolean isGlobalVariable() {
        return this.fType == 7;
    }

    public boolean isConstructor() {
        return this.fType == 6;
    }

    public void setIdentifier(String fIdentifier) {
        this.fIdentifier = fIdentifier;
    }

    public void setType(int fType) {
        this.fType = fType;
    }

    public String toString() {
        switch (this.fType) {
            case 1: {
                return "class - ";
            }
            case 6: {
                return "constructor - ";
            }
            case 5: {
                return "define - ";
            }
            case 2: {
                return "function - ";
            }
            case 7: {
                return "global variable - ";
            }
            case 4: {
                return "method - ";
            }
            case 3: {
                return "variable - ";
            }
        }
        return "";
    }
}

