/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.actions;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.phpdt.core.compiler.ITerminalSymbols;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.compiler.parser.SyntaxError;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IFileEditorInput;

public class IncludesScanner
implements ITerminalSymbols {
    private IProject fProject;
    private IFileEditorInput fEditorInput;
    private HashSet fSet;

    public IncludesScanner(IProject project, IFileEditorInput editorInput) {
        this.fProject = project;
        this.fEditorInput = editorInput;
        this.fSet = new HashSet();
    }

    public void addFile(IFile fileToParse) {
        try {
            if (fileToParse.exists()) {
                this.addInputStream(new BufferedInputStream(fileToParse.getContents()), fileToParse.getProjectRelativePath().toString());
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addInputStream(InputStream stream, String filePath) throws CoreException {
        try {
            try {
                if (this.fSet.add(filePath)) {
                    this.parseIdentifiers(Util.getInputStreamAsCharArray(stream, -1, null));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        stream.close();
    }

    private int getNextToken(Scanner scanner) {
        try {
            int token = scanner.getNextToken();
            return token;
        }
        catch (InvalidInputException invalidInputException) {
            return 1;
        }
    }

    private void parseIdentifiers(char[] charArray) {
        Scanner scanner = new Scanner(false, false, false, false, true, null, null, true);
        scanner.setSource(charArray);
        scanner.setPHPMode(false);
        int token = this.getNextToken(scanner);
        try {
            while (token != 0) {
                if (token == 1016 || token == 1017 || token == 1018 || token == 1019) {
                    while (token != 0 && token != 1 && token != 140 && token != 129 && token != 130 && token != 131) {
                        token = this.getNextToken(scanner);
                        if (token != 136 && token != 154) continue;
                        char[] includeName = scanner.getCurrentStringLiteralSource();
                        try {
                            System.out.println(includeName);
                            IFile file = this.getIncludeFile(new String(includeName));
                            this.addFile(file);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                }
                token = this.getNextToken(scanner);
            }
        }
        catch (SyntaxError syntaxError) {}
    }

    private IContainer getWorkingLocation(IFileEditorInput editorInput) {
        if (editorInput == null || editorInput.getFile() == null) {
            return null;
        }
        return editorInput.getFile().getParent();
    }

    public IFile getIncludeFile(String relativeFilename) {
        Path path;
        IContainer container = this.getWorkingLocation(this.fEditorInput);
        IFile file = null;
        if (relativeFilename.startsWith("../")) {
            Path path2 = new Path(relativeFilename);
            file = container.getFile((IPath)path2);
            return file;
        }
        int index = relativeFilename.lastIndexOf(47);
        if (index >= 0 && (file = this.fProject.getFile((IPath)(path = new Path(relativeFilename)))).exists()) {
            return file;
        }
        path = new Path(relativeFilename);
        file = container.getFile((IPath)path);
        return file;
    }

    public List getList() {
        ArrayList list = new ArrayList();
        list.addAll(this.fSet);
        return list;
    }

    public Set getSet() {
        return this.fSet;
    }
}

