/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui.wizards;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.externaltools.internal.ui.StatusInfo;
import net.sourceforge.phpdt.internal.ui.viewsupport.IViewPartInputProvider;
import net.sourceforge.phpdt.internal.ui.wizards.NewWizardMessages;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.DialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.LayoutUtil;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import net.sourceforge.phpdt.ui.wizards.NewElementWizardPage;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private StringButtonDialogField fContainerDialogField;
    private IPackageFragmentRoot fCurrRoot;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(NewWizardMessages.getString("NewContainerWizardPage.container.label"));
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.getString("NewContainerWizardPage.container.button"));
        this.fContainerStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    protected void initContainerPage(IJavaElement elem) {
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        Object selectedElement;
        IJavaElement jelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sourceforge.phpdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelem = (IJavaElement)adaptable.getAdapter((Class)clazz)) == null) {
                IResource resource;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null && resource.getType() != 8) {
                    while (jelem == null && resource.getType() != 4) {
                        resource = resource.getParent();
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("net.sourceforge.phpdt.core.IJavaElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        jelem = (IJavaElement)resource.getAdapter((Class)clazz3);
                    }
                    if (jelem == null) {
                        jelem = JavaCore.create(resource);
                    }
                }
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchPart part = PHPeclipsePlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = PHPeclipsePlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create(this.getWorkspaceRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                PHPeclipsePlugin.log((Throwable)((Object)e));
            }
        }
        return jelem;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.fContainerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField field) {
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrRoot = null;
        String str = this.getPackageFragmentRootText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.getString("NewContainerWizardPage.error.EnterContainerName"));
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.ProjectClosed", proj.getFullPath().toString()));
                    return status;
                }
                JavaCore.create(proj);
                return status;
            }
            status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.NotAFolder", str));
            return status;
        }
        status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.ContainerDoesNotExist", str));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.fContainerDialogField.getText();
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

