/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ltk.ui.actions;

import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierDelegate;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierInfo;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierRefactoring;
import net.sourceforge.phpdt.ltk.core.RenamePHPProcessor;
import net.sourceforge.phpdt.ltk.ui.UITexts;
import net.sourceforge.phpdt.ltk.ui.wizards.RenameIdentifierWizard;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import net.sourceforge.phpeclipse.phpeditor.php.PHPWordExtractor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class RenamePHPIdentifier
implements IEditorActionDelegate {
    private ISelection selection;
    private IEditorPart targetEditor;
    private boolean onPHPFile;
    private RenameIdentifierInfo info = new RenameIdentifierInfo();

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
        this.onPHPFile = false;
        IFile file = this.getFile();
        if (file != null && PHPFileUtil.isPHPFile(file)) {
            this.onPHPFile = true;
        }
    }

    public void run(IAction action) {
        if (!this.onPHPFile) {
            this.refuse();
        } else if (this.selection != null && this.selection instanceof ITextSelection) {
            PHPEditor editor;
            String word = null;
            Point point = null;
            if (this.targetEditor != null && this.targetEditor instanceof PHPEditor && (editor = (PHPEditor)this.targetEditor) != null) {
                int pos;
                ITextSelection textSelection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                point = PHPWordExtractor.findWord(doc, pos = textSelection.getOffset());
                if (point != null) {
                    try {
                        word = doc.get(point.x, point.y);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            this.applySelection((ITextSelection)this.selection, word, point);
            if (RenamePHPIdentifier.saveAll()) {
                this.openWizard();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private void applySelection(ITextSelection textSelection, String word, Point point) {
        if (word != null) {
            this.info.setOldName(word);
            this.info.setNewName(word);
            this.info.setOffset(point.x);
        } else {
            this.info.setOldName(textSelection.getText());
            this.info.setNewName(textSelection.getText());
            this.info.setOffset(textSelection.getOffset());
        }
        this.info.setSourceFile(this.getFile());
    }

    private void refuse() {
        String title = UITexts.renameProperty_refuseDlg_title;
        String message = UITexts.renameProperty_refuseDlg_message;
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
    }

    private static boolean saveAll() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return IDE.saveAllEditors((IResource[])new IResource[]{workspaceRoot}, (boolean)false);
    }

    private void openWizard() {
        RenameIdentifierDelegate delegate = new RenameIdentifierDelegate(this.info);
        RenamePHPProcessor processor = new RenamePHPProcessor(this.info, delegate);
        RenameIdentifierRefactoring ref = new RenameIdentifierRefactoring(processor);
        RenameIdentifierWizard wizard = new RenameIdentifierWizard(ref, this.info);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = "";
            op.run(this.getShell(), titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    private Shell getShell() {
        Shell result = null;
        result = this.targetEditor != null ? this.targetEditor.getSite().getShell() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return result;
    }

    private final IFile getFile() {
        ITextEditor editor;
        IEditorInput input;
        IFile result = null;
        if (this.targetEditor instanceof ITextEditor && (input = (editor = (ITextEditor)this.targetEditor).getEditorInput()) instanceof IFileEditorInput) {
            result = ((IFileEditorInput)input).getFile();
        }
        return result;
    }
}

