/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionManager;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionUI;
import net.sourceforge.phpdt.internal.ui.text.template.AbstractProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;

public class SQLProposal
extends AbstractProposal {
    private final TemplateContext fContext;
    private final Image fImage_var;
    private final IRegion fRegion;
    private final String fColumnName;
    private final String fTableName;
    private int fRelevance;

    public SQLProposal(String tableName, TemplateContext context, IRegion region, ITextViewer viewer, Image image_var) {
        super(viewer);
        this.fTableName = tableName;
        this.fColumnName = null;
        this.fContext = context;
        this.fImage_var = image_var;
        this.fRegion = region;
        this.fRelevance = 0;
    }

    public SQLProposal(String tableName, String columnName, TemplateContext context, IRegion region, ITextViewer viewer, Image image_var) {
        super(viewer);
        this.fTableName = tableName;
        this.fColumnName = columnName;
        this.fContext = context;
        this.fImage_var = image_var;
        this.fRegion = region;
        this.fRelevance = 0;
    }

    public void apply(IDocument document) {
        try {
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            String resultString = this.fTableName;
            if (this.fColumnName != null) {
                resultString = this.fColumnName;
            }
            document.replace(start, end - start, resultString);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(resultString.length() + start);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    public String getAdditionalProposalInfo() {
        if (this.fColumnName == null) {
            return SQLProposal.textToHTML(this.fTableName);
        }
        return String.valueOf(this.fColumnName) + " (Table: " + this.fTableName + ")";
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.fColumnName == null) {
            return this.fTableName;
        }
        return String.valueOf(this.fColumnName) + " (Table: " + this.fTableName + ")";
    }

    public Image getImage() {
        return this.fImage_var;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }
}

