/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import net.sourceforge.phpdt.internal.corext.template.TemplateMessages;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionManager;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionUI;
import net.sourceforge.phpdt.internal.ui.text.template.AbstractProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.php.PHPFunction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;

public class BuiltInProposal
extends AbstractProposal {
    private final TemplateContext fContext;
    private final PHPFunction fFunction;
    private final IRegion fRegion;
    private final String fBuiltinFunctionName;

    public BuiltInProposal(String functionName, PHPFunction function, TemplateContext context, IRegion region, ITextViewer viewer) {
        super(viewer);
        this.fBuiltinFunctionName = functionName;
        this.fFunction = function;
        this.fContext = context;
        this.fRegion = region;
    }

    public void apply(IDocument document) {
        try {
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            document.replace(start, end - start, String.valueOf(this.fBuiltinFunctionName) + "()");
            LinkedPositionManager manager = new LinkedPositionManager(document);
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(this.fBuiltinFunctionName.length() + start + 1);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    public String getAdditionalProposalInfo() {
        return this.fFunction.getHoverText();
    }

    public IContextInformation getContextInformation() {
        String contextInfoString;
        if (this.fContextInfo == null && (contextInfoString = this.fFunction.getHoverText()) != null && contextInfoString.length() > 0) {
            int i1;
            int i0 = contextInfoString.indexOf(40);
            int newline = contextInfoString.indexOf(10);
            this.fContextInfo = i0 >= 0 && (i0 < newline || newline < 0) ? ((i1 = contextInfoString.indexOf(41, i0 + 1)) > 0 ? new ContextInformation(null, contextInfoString.substring(i0 + 1, i1)) : new ContextInformation(null, contextInfoString)) : new ContextInformation(null, contextInfoString);
        }
        return this.fContextInfo;
    }

    public String getDisplayString() {
        return String.valueOf(this.fBuiltinFunctionName) + TemplateMessages.getString("TemplateProposal.delimiter") + this.fFunction.getUsage();
    }

    public Image getImage() {
        return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.builtin_obj.gif");
    }

    public int getRelevance() {
        if (this.fContext instanceof JavaContext) {
            JavaContext context = (JavaContext)this.fContext;
            switch (context.getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return 50;
                }
            }
            return 0;
        }
        return 50;
    }
}

