/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.java.hover;

import java.util.List;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.internal.ui.text.HTMLTextPresenter;
import net.sourceforge.phpdt.internal.ui.text.JavaWordFinder;
import net.sourceforge.phpdt.internal.ui.text.java.hover.JavaHoverMessages;
import net.sourceforge.phpdt.ui.text.java.hover.IJavaEditorTextHover;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.keys.KeySequence;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover {
    private IEditorPart fEditor;
    private ICommand fCommand;

    public AbstractJavaEditorTextHover() {
        PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        this.fCommand = null;
    }

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    protected String getHoverInfo(IJavaElement[] javaElements) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractJavaEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (!PHPeclipsePlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        KeySequence[] sequences = this.getKeySequences();
        if (sequences == null) {
            return null;
        }
        String keySequence = sequences[0].format();
        return JavaHoverMessages.getFormattedString("JavaTextHover.makeStickyHint", keySequence);
    }

    private KeySequence[] getKeySequences() {
        List list;
        if (this.fCommand != null && !(list = this.fCommand.getKeySequenceBindings()).isEmpty()) {
            KeySequence[] keySequences = new KeySequence[list.size()];
            int i = 0;
            while (i < keySequences.length) {
                keySequences[i] = ((IKeySequenceBinding)list.get(i)).getKeySequence();
                ++i;
            }
            return keySequences;
        }
        return null;
    }
}

