/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text;

import net.sourceforge.phpdt.internal.ui.text.JavaColorManager;
import net.sourceforge.phpdt.internal.ui.text.phpdoc.PHPDocCompletionProcessor;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpdt.ui.text.JavaTextTools;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.php.HTMLCompletionProcessor;
import net.sourceforge.phpeclipse.phpeditor.php.PHPCompletionProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    private static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    private static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    private static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    private static final String COMPLETION_REPLACEMENT_FOREGROUND = "content_assist_completion_replacement_foreground";
    private static final String COMPLETION_REPLACEMENT_BACKGROUND = "content_assist_completion_replacement_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String AUTOACTIVATION_TRIGGERS_JAVA = "content_assist_autoactivation_triggers_php";
    private static final String AUTOACTIVATION_TRIGGERS_JAVADOC = "content_assist_autoactivation_triggers_phpdoc";
    private static final String AUTOACTIVATION_TRIGGERS_HTML = "content_assist_autoactivation_triggers_html";
    private static final String SHOW_VISIBLE_PROPOSALS = "content_assist_show_visible_proposals";
    private static final String ORDER_PROPOSALS = "content_assist_order_proposals";
    private static final String CASE_SENSITIVITY = "content_assist_case_sensitivity";
    private static final String ADD_IMPORT = "content_assist_add_import";
    private static final String INSERT_COMPLETION = "content_assist_insert_completion";
    private static final String FILL_METHOD_ARGUMENTS = "content_assist_fill_method_arguments";
    private static final String GUESS_METHOD_ARGUMENTS = "content_assist_guess_method_arguments";

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        JavaTextTools textTools = PHPeclipsePlugin.getDefault().getJavaTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private static PHPCompletionProcessor getJavaProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("___php_partitioning");
        if (p instanceof PHPCompletionProcessor) {
            return (PHPCompletionProcessor)p;
        }
        return null;
    }

    private static PHPDocCompletionProcessor getJavaDocProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__php_phpdoc_comment");
        if (p instanceof PHPDocCompletionProcessor) {
            return (PHPDocCompletionProcessor)p;
        }
        return null;
    }

    private static HTMLCompletionProcessor getHTMLProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__html");
        if (p instanceof HTMLCompletionProcessor) {
            return (HTMLCompletionProcessor)p;
        }
        return null;
    }

    private static void configureJavaProcessor(ContentAssistant assistant, IPreferenceStore store) {
        PHPCompletionProcessor pcp = ContentAssistPreference.getJavaProcessor(assistant);
        if (pcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVA);
        if (triggers != null) {
            pcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean(ORDER_PROPOSALS);
        pcp.orderProposalsAlphabetically(enabled);
    }

    private static void configureJavaDocProcessor(ContentAssistant assistant, IPreferenceStore store) {
        PHPDocCompletionProcessor pdcp = ContentAssistPreference.getJavaDocProcessor(assistant);
        if (pdcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVADOC);
        if (triggers != null) {
            pdcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean(CASE_SENSITIVITY);
        pdcp.restrictProposalsToMatchingCases(enabled);
        enabled = store.getBoolean(ORDER_PROPOSALS);
        pdcp.orderProposalsAlphabetically(enabled);
    }

    private static void configureHTMLProcessor(ContentAssistant assistant, IPreferenceStore store) {
        HTMLCompletionProcessor hcp = ContentAssistPreference.getHTMLProcessor(assistant);
        if (hcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_HTML);
        if (triggers != null) {
            hcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean(ORDER_PROPOSALS);
        hcp.orderProposalsAlphabetically(enabled);
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        JavaTextTools textTools = PHPeclipsePlugin.getDefault().getJavaTextTools();
        JavaColorManager manager = textTools.getColorManager();
        boolean enabled = store.getBoolean(AUTOACTIVATION);
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND, manager);
        assistant.setProposalSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND, manager);
        assistant.setProposalSelectorBackground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND, manager);
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND, manager);
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        ContentAssistPreference.configureJavaProcessor(assistant, store);
        ContentAssistPreference.configureJavaDocProcessor(assistant, store);
        ContentAssistPreference.configureHTMLProcessor(assistant, store);
    }

    private static void changeJavaProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        PHPCompletionProcessor jcp = ContentAssistPreference.getJavaProcessor(assistant);
        if (jcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_JAVA.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVA);
            if (triggers != null) {
                jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (ORDER_PROPOSALS.equals(key)) {
            boolean enable = store.getBoolean(ORDER_PROPOSALS);
            jcp.orderProposalsAlphabetically(enable);
        }
    }

    private static void changeJavaDocProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        PHPDocCompletionProcessor jdcp = ContentAssistPreference.getJavaDocProcessor(assistant);
        if (jdcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_JAVADOC.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVADOC);
            if (triggers != null) {
                jdcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (CASE_SENSITIVITY.equals(key)) {
            boolean enabled = store.getBoolean(CASE_SENSITIVITY);
            jdcp.restrictProposalsToMatchingCases(enabled);
        } else if (ORDER_PROPOSALS.equals(key)) {
            boolean enable = store.getBoolean(ORDER_PROPOSALS);
            jdcp.orderProposalsAlphabetically(enable);
        }
    }

    private static void changeHTMLProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        HTMLCompletionProcessor jdcp = ContentAssistPreference.getHTMLProcessor(assistant);
        if (jdcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_HTML.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS_HTML);
            if (triggers != null) {
                jdcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (ORDER_PROPOSALS.equals(key)) {
            boolean enable = store.getBoolean(ORDER_PROPOSALS);
            jdcp.orderProposalsAlphabetically(enable);
        }
    }

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION.equals(p)) {
            boolean enabled = store.getBoolean(AUTOACTIVATION);
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PROPOSALS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND);
            assistant.setProposalSelectorForeground(c);
        } else if (PROPOSALS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND);
            assistant.setProposalSelectorBackground(c);
        } else if (PARAMETERS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if (PARAMETERS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        }
        ContentAssistPreference.changeJavaProcessor(assistant, store, p);
        ContentAssistPreference.changeJavaDocProcessor(assistant, store, p);
        ContentAssistPreference.changeHTMLProcessor(assistant, store, p);
    }

    public static boolean fillArgumentsOnMethodCompletion(IPreferenceStore store) {
        return store.getBoolean(FILL_METHOD_ARGUMENTS);
    }
}

