/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.util;

public class CharArrayOps {
    public static String[] charcharToString(char[][] charchar) {
        if (charchar == null) {
            return null;
        }
        String[] strings = new String[charchar.length];
        int i = 0;
        while (i < charchar.length) {
            strings[i] = new String(charchar[i]);
            ++i;
        }
        return strings;
    }

    public static String charToString(char[] chars) {
        if (chars == null) {
            return null;
        }
        return new String(chars);
    }

    public static char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static boolean equals(char[] first, char[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        int length = first.length;
        while (i < length) {
            if (first[i] != second[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int indexOf(char character, char[] buffer, int offset) {
        int i = offset;
        while (i < buffer.length) {
            if (buffer[i] == character) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static char[] subarray(char[] src, int start, int length) {
        if (src == null) {
            return null;
        }
        int srcLength = src.length;
        if (start < 0 || start >= srcLength) {
            return null;
        }
        if (length < 0 || start + length > srcLength) {
            return null;
        }
        if (srcLength == length && start == 0) {
            return src;
        }
        char[] result = new char[length];
        if (length > 0) {
            System.arraycopy(src, start, result, 0, length);
        }
        return result;
    }

    public static String substring(char[] src, int start, int length) {
        char[] chars = CharArrayOps.subarray(src, start, length);
        if (chars != null) {
            return new String(chars);
        }
        return null;
    }
}

