/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.util;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Argument;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.core.util.ASTNodeFinder;
import net.sourceforge.phpdt.internal.core.util.Util;

public class ASTNodeFinder {
    private CompilationUnitDeclaration unit;

    public ASTNodeFinder(CompilationUnitDeclaration unit) {
        this.unit = unit;
    }

    public FieldDeclaration findField(IField fieldHandle) {
        TypeDeclaration typeDecl = this.findType((IType)fieldHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        FieldDeclaration[] fields = typeDecl.fields;
        if (fields != null) {
            char[] fieldName = fieldHandle.getElementName().toCharArray();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                FieldDeclaration field = fields[i];
                if (CharOperation.equals(fieldName, field.name)) {
                    return field;
                }
                ++i;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration findMethod(IMethod methodHandle) {
        TypeDeclaration typeDecl = this.findType((IType)methodHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        AbstractMethodDeclaration[] methods = typeDecl.methods;
        if (methods != null) {
            char[] selector = methodHandle.getElementName().toCharArray();
            String[] parameterTypeSignatures = methodHandle.getParameterTypes();
            int parameterCount = parameterTypeSignatures.length;
            int i = 0;
            int length = methods.length;
            while (i < length) {
                block7: {
                    AbstractMethodDeclaration method = methods[i];
                    if (CharOperation.equals(selector, method.selector)) {
                        int argsLength;
                        Argument[] args = method.arguments;
                        int n = argsLength = args == null ? 0 : args.length;
                        if (argsLength == parameterCount) {
                            int j = 0;
                            while (j < parameterCount) {
                                TypeReference type = args[j].type;
                                String signature = Util.typeSignature(type);
                                if (signature.equals(parameterTypeSignatures[j])) {
                                    ++j;
                                    continue;
                                }
                                break block7;
                            }
                            return method;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration findType(IType typeHandle) {
        IJavaElement parent = typeHandle.getParent();
        char[] typeName = typeHandle.getElementName().toCharArray();
        boolean findAnonymous = typeName.length == 0;
        switch (parent.getElementType()) {
            class Visitor
            extends ASTVisitor {
                TypeDeclaration result;
                int count;
                final /* synthetic */ ASTNodeFinder this$0;
                private final /* synthetic */ boolean val$findAnonymous;
                private final /* synthetic */ char[] val$typeName;

                Visitor(ASTNodeFinder aSTNodeFinder, boolean bl, char[] cArray) {
                    this.this$0 = aSTNodeFinder;
                    this.val$findAnonymous = bl;
                    this.val$typeName = cArray;
                    this.count = 0;
                }

                public boolean visit(TypeDeclaration typeDeclaration, BlockScope scope) {
                    if (this.result != null) {
                        return false;
                    }
                    if (!this.val$findAnonymous && CharOperation.equals(this.val$typeName, typeDeclaration.name)) {
                        this.result = typeDeclaration;
                    }
                    return false;
                }
            }
            case 5: {
                ArrayList types = this.unit.types;
                if (types == null) break;
                int i = 0;
                int length = types.size();
                while (i < length) {
                    TypeDeclaration type = (TypeDeclaration)types.get(i);
                    if (CharOperation.equals(typeName, type.name)) {
                        return type;
                    }
                    ++i;
                }
                break;
            }
            case 7: {
                TypeDeclaration parentDecl = this.findType((IType)parent);
                if (parentDecl != null) break;
                return null;
            }
            case 8: {
                FieldDeclaration fieldDecl = this.findField((IField)parent);
                if (fieldDecl == null) {
                    return null;
                }
                Visitor visitor = new Visitor(this, findAnonymous, typeName);
                fieldDecl.traverse((ASTVisitor)visitor, null);
                return visitor.result;
            }
            case 9: {
                AbstractMethodDeclaration methodDecl = this.findMethod((IMethod)parent);
                if (methodDecl == null) {
                    return null;
                }
                Visitor visitor = new Visitor(this, findAnonymous, typeName);
                methodDecl.traverse((ASTVisitor)visitor, (ClassScope)null);
                return visitor.result;
            }
        }
        return null;
    }
}

