/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.builder.IdentifierIndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ParserVisitor
implements IResourceDeltaVisitor {
    final IProgressMonitor fMonitor;
    final IProject fProject;

    public ParserVisitor(IProject iProject, IProgressMonitor monitor) {
        this.fMonitor = monitor;
        this.fProject = iProject;
    }

    protected void checkCancel() {
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        int resourceType = resource.getType();
        this.checkCancel();
        IdentifierIndexManager indexManager = PHPeclipsePlugin.getDefault().getIndexManager(this.fProject);
        switch (delta.getKind()) {
            case 1: {
                if (resourceType != 1 || resource.getFileExtension() == null || !PHPFileUtil.isPHPFile((IFile)resource)) break;
                this.fMonitor.worked(1);
                this.fMonitor.subTask("Adding: " + resource.getFullPath());
                indexManager.addFile((IFile)resource);
                break;
            }
            case 4: {
                if (resourceType != 1 || resource.getFileExtension() == null || !PHPFileUtil.isPHPFile((IFile)resource)) break;
                this.fMonitor.worked(1);
                this.fMonitor.subTask("Changing: " + resource.getFullPath());
                indexManager.changeFile((IFile)resource);
                break;
            }
            case 2: {
                if (resourceType != 1 || resource.getFileExtension() == null || !PHPFileUtil.isPHPFile((IFile)resource)) break;
                this.fMonitor.worked(1);
                this.fMonitor.subTask("Removing: " + resource.getFullPath());
                indexManager.removeFile((IFile)resource);
            }
        }
        return true;
    }
}

