/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.core.search.IJavaSearchConstants;
import net.sourceforge.phpdt.core.search.ITypeNameRequestor;
import net.sourceforge.phpdt.internal.codeassist.ISearchRequestor;
import net.sourceforge.phpdt.internal.codeassist.ISearchableNameEnvironment;
import net.sourceforge.phpdt.internal.compiler.env.ISourceType;
import net.sourceforge.phpdt.internal.compiler.env.NameEnvironmentAnswer;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaElementRequestor;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.NameLookup;
import net.sourceforge.phpdt.internal.core.SearchableEnvironmentRequestor;
import net.sourceforge.phpdt.internal.core.SourceType;
import net.sourceforge.phpdt.internal.core.SourceTypeElementInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class SearchableEnvironment
implements ISearchableNameEnvironment,
IJavaSearchConstants {
    protected NameLookup nameLookup;
    protected ICompilationUnit unitToSkip;
    protected IJavaProject project;

    public SearchableEnvironment(IJavaProject project) throws JavaModelException {
        this.project = project;
        this.nameLookup = ((JavaProject)project).getNameLookup();
    }

    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner) throws JavaModelException {
        this.project = project;
        this.nameLookup = project.newNameLookup(owner);
    }

    protected NameEnvironmentAnswer find(String typeName, String packageName) {
        IType type;
        if (packageName == null) {
            packageName = "";
        }
        if (this.nameLookup != null && (type = this.nameLookup.findType(typeName, packageName, false, 6)) != null) {
            try {
                SourceTypeElementInfo sourceType;
                ISourceType topLevelType = sourceType = (SourceTypeElementInfo)((SourceType)type).getElementInfo();
                while (topLevelType.getEnclosingType() != null) {
                    topLevelType = topLevelType.getEnclosingType();
                }
                IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                ISourceType[] sourceTypes = new ISourceType[types.length];
                sourceTypes[0] = sourceType;
                int i = 0;
                int index = 1;
                while (i < types.length) {
                    ISourceType otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                    if (!otherType.equals(topLevelType)) {
                        sourceTypes[index++] = otherType;
                    }
                    ++i;
                }
                return new NameEnvironmentAnswer(sourceTypes);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor) {
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        if (compoundTypeName == null) {
            return null;
        }
        int length = compoundTypeName.length;
        if (length <= 1) {
            if (length == 0) {
                return null;
            }
            return this.find(new String(compoundTypeName[0]), null);
        }
        int lengthM1 = length - 1;
        char[][] packageName = new char[lengthM1][];
        System.arraycopy(compoundTypeName, 0, packageName, 0, lengthM1);
        return this.find(new String(compoundTypeName[lengthM1]), CharOperation.toString(packageName));
    }

    public NameEnvironmentAnswer findType(char[] name, char[][] packageName) {
        if (name == null) {
            return null;
        }
        return this.find(new String(name), packageName == null || packageName.length == 0 ? null : CharOperation.toString(packageName));
    }

    public void findTypes(char[] prefix, final ISearchRequestor storage) {
        String excludePath;
        if (this.unitToSkip != null) {
            if (!(this.unitToSkip instanceof IJavaElement)) {
                this.findTypes(new String(prefix), storage, 6);
                return;
            }
            excludePath = this.unitToSkip.getPath().toString();
        } else {
            excludePath = null;
        }
        int lastDotIndex = CharOperation.lastIndexOf('.', prefix);
        if (lastDotIndex < 0) {
            CharOperation.toLowerCase(prefix);
        } else {
            CharOperation.subarray(prefix, 0, lastDotIndex);
            CharOperation.toLowerCase(CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length));
        }
        new IProgressMonitor(){
            boolean isCanceled = false;

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return this.isCanceled;
            }

            public void setCanceled(boolean value) {
                this.isCanceled = value;
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
        new ITypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (excludePath != null && excludePath.equals(path)) {
                    return;
                }
                if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                    return;
                }
                storage.acceptClass(packageName, simpleTypeName, 1);
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (excludePath != null && excludePath.equals(path)) {
                    return;
                }
                if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                    return;
                }
                storage.acceptInterface(packageName, simpleTypeName, 1);
            }
        };
    }

    private void findTypes(String prefix, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip);
        int index = prefix.lastIndexOf(46);
        if (index == -1) {
            this.nameLookup.seekTypes(prefix, null, true, type, requestor);
        } else {
            String packageName = prefix.substring(0, index);
            JavaElementRequestor elementRequestor = new JavaElementRequestor();
            this.nameLookup.seekPackageFragments(packageName, false, elementRequestor);
            IPackageFragment[] fragments = elementRequestor.getPackageFragments();
            if (fragments != null) {
                String className = prefix.substring(index + 1);
                int i = 0;
                int length = fragments.length;
                while (i < length) {
                    if (fragments[i] != null) {
                        this.nameLookup.seekTypes(className, fragments[i], true, type, requestor);
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isPackage(char[][] parentPackageName, char[] subPackageName) {
        if (subPackageName == null || CharOperation.contains('.', subPackageName)) {
            return false;
        }
        if (parentPackageName == null || parentPackageName.length == 0) {
            return this.isTopLevelPackage(subPackageName);
        }
        int i = 0;
        int length = parentPackageName.length;
        while (i < length) {
            if (parentPackageName[i] == null || CharOperation.contains('.', parentPackageName[i])) {
                return false;
            }
            ++i;
        }
        String packageName = new String(CharOperation.concatWith(parentPackageName, subPackageName, '.'));
        return this.nameLookup.findPackageFragments(packageName, false) != null;
    }

    public boolean isTopLevelPackage(char[] packageName) {
        return packageName != null && !CharOperation.contains('.', packageName) && this.nameLookup.findPackageFragments(new String(packageName), false) != null;
    }

    protected String toStringChar(char[] name) {
        return "[" + new String(name) + "]";
    }

    protected String toStringCharChar(char[][] names) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            result.append(this.toStringChar(names[i]));
            ++i;
        }
        return result.toString();
    }

    public void cleanup() {
    }
}

