/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.internal.core.CompilationUnit;
import net.sourceforge.phpdt.internal.core.DefaultWorkingCopyOwner;
import net.sourceforge.phpdt.internal.core.Openable;
import net.sourceforge.phpdt.internal.core.OpenableElementInfo;
import net.sourceforge.phpdt.internal.core.PackageFragmentInfo;
import net.sourceforge.phpdt.internal.core.PackageFragmentRoot;
import net.sourceforge.phpdt.internal.core.util.MementoTokenizer;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class PackageFragment
extends Openable
implements IPackageFragment {
    protected static ICompilationUnit[] fgEmptyCompilationUnitList = new ICompilationUnit[0];

    protected PackageFragment(PackageFragmentRoot root, String name) {
        super(root, name);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        this.getKind();
        String extType = "php";
        HashSet vChildren = new HashSet();
        try {
            PackageFragmentRoot root = this.getPackageFragmentRoot();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            IResource[] members = ((IContainer)underlyingResource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                String extension;
                IResource child = members[i];
                if (child.getType() == 2 || Util.isExcluded(child, exclusionPatterns) || (extension = child.getProjectRelativePath().getFileExtension()) == null || extension.equalsIgnoreCase(extType)) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        IJavaElement[] children = new IJavaElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public ICompilationUnit createCompilationUnit(String name, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        return null;
    }

    protected Object createElementInfo() {
        return new PackageFragmentInfo();
    }

    public ICompilationUnit getCompilationUnit(String cuName) {
        if (!PHPFileUtil.isValidPHPUnitName(cuName)) {
            throw new IllegalArgumentException(Util.bind("convention.unit.notJavaName"));
        }
        return new CompilationUnit(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public ICompilationUnit[] getCompilationUnits() throws JavaModelException {
        if (this.getKind() == 2) {
            return fgEmptyCompilationUnitList;
        }
        ArrayList list = this.getChildrenOfType(5);
        ICompilationUnit[] array = new ICompilationUnit[list.size()];
        list.toArray(array);
        return array;
    }

    public int getElementType() {
        return 4;
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '{': {
                String cuName = memento.nextToken();
                CompilationUnit cu = new CompilationUnit(this, cuName, owner);
                return cu.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public int getKind() throws JavaModelException {
        return ((IPackageFragmentRoot)this.getParent()).getKind();
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return root.getPath().append(this.getElementName());
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            return root.getResource();
        }
        return ((IContainer)root.getResource()).getFolder((IPath)new Path(this.getElementName()));
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource rootResource = this.parent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        return rootResource;
    }

    public boolean isDefaultPackage() {
        return this.getElementName().length() == 0;
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (tab == 0) {
            super.toStringChildren(tab, buffer, info);
        }
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("[default]");
        } else {
            buffer.append(this.getElementName());
        }
        if (info == null) {
            buffer.append(" (not open)");
        } else if (tab > 0) {
            buffer.append(" (...)");
        }
    }
}

