/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.Map;
import java.util.Stack;
import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.compiler.ISourceElementRequestor;
import net.sourceforge.phpdt.internal.compiler.parser.Parser;
import net.sourceforge.phpdt.internal.compiler.util.HashtableOfObject;
import net.sourceforge.phpdt.internal.core.CompilationUnitElementInfo;
import net.sourceforge.phpdt.internal.core.ImportContainer;
import net.sourceforge.phpdt.internal.core.ImportDeclaration;
import net.sourceforge.phpdt.internal.core.ImportDeclarationElementInfo;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaElementInfo;
import net.sourceforge.phpdt.internal.core.SourceField;
import net.sourceforge.phpdt.internal.core.SourceFieldElementInfo;
import net.sourceforge.phpdt.internal.core.SourceMethod;
import net.sourceforge.phpdt.internal.core.SourceMethodElementInfo;
import net.sourceforge.phpdt.internal.core.SourceRefElementInfo;
import net.sourceforge.phpdt.internal.core.SourceTypeElementInfo;
import net.sourceforge.phpdt.internal.core.util.ReferenceInfoAdapter;
import net.sourceforge.phpdt.internal.corext.Assert;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected ICompilationUnit unit;
    protected CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected Map newElements;
    protected Stack infoStack;
    protected Stack handleStack;
    protected char[] fSourceFileName = null;
    protected char[] fPackageName = null;
    protected int fRefCount = 0;
    protected static int fgReferenceAllocation = 50;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static String[] fgEmptyStringArray = new String[0];
    protected static byte[] fgEmptyByte = new byte[0];
    protected static char[][] fgEmptyCharChar = new char[0][];
    protected static char[] fgEmptyChar = new char[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map newElements) throws JavaModelException {
        this.unit = unit;
        this.unitInfo = unitInfo;
        this.newElements = newElements;
        this.fSourceFileName = unit.getElementName().toCharArray();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue(false);
        }
        ICompilationUnit parentCU = (ICompilationUnit)((Object)parentHandle);
        ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            this.importContainerInfo.setIsStructureKnown(true);
            parentInfo.addChild(importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        String importName = onDemand ? String.valueOf(new String(name)) + ".*" : new String(name);
        ImportDeclaration handle = new ImportDeclaration(importContainer, importName);
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setName(name);
        info.setOnDemand(onDemand);
        this.importContainerInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptProblem(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = Signature.createTypeSignature(typeNames[i], false);
            ++i;
        }
        return typeSigs;
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, superclass, superinterfaces);
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, null, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, true);
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = new SourceField(parentHandle, new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setTypeName(type);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, null, superinterfaces);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, false);
    }

    protected void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, boolean isConstructor) {
        char[] cArray;
        SourceTypeElementInfo parentInfo = null;
        try {
            parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        }
        catch (ClassCastException classCastException) {}
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceMethod handle = null;
        if (parameterTypes == null) {
            parameterTypes = fgEmptyCharChar;
        }
        if (parameterNames == null) {
            parameterNames = fgEmptyCharChar;
        }
        if (exceptionTypes == null) {
            exceptionTypes = fgEmptyCharChar;
        }
        String[] parameterTypeSigs = CompilationUnitStructureRequestor.convertTypeNamesToSigs(parameterTypes);
        handle = new SourceMethod(parentHandle, new String(name), parameterTypeSigs);
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = new SourceMethodElementInfo();
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setConstructor(isConstructor);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setArgumentTypeNames(parameterTypes);
        if (returnType == null) {
            char[] cArray2 = new char[4];
            cArray2[0] = 118;
            cArray2[1] = 111;
            cArray2[2] = 105;
            cArray = cArray2;
            cArray2[3] = 100;
        } else {
            cArray = returnType;
        }
        info.setReturnType(cArray);
        info.setExceptionTypeNames(exceptionTypes);
        if (parentInfo == null) {
            this.unitInfo.addChild(handle);
        } else {
            parentInfo.addChild(handle);
        }
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    protected void enterType(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        char[] enclosingTypeName = null;
        char[] qualifiedName = null;
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        IType handle = null;
        String nameString = new String(name);
        if (parentHandle.getElementType() == 5) {
            handle = ((ICompilationUnit)((Object)parentHandle)).getType(nameString);
            qualifiedName = this.fPackageName == null ? nameString.toCharArray() : (String.valueOf(new String(this.fPackageName)) + "." + nameString).toCharArray();
        } else if (parentHandle.getElementType() == 7) {
            handle = ((IType)((Object)parentHandle)).getType(nameString);
            enclosingTypeName = ((SourceTypeElementInfo)parentInfo).getName();
            qualifiedName = (String.valueOf(new String(((SourceTypeElementInfo)parentInfo).getQualifiedName())) + "." + nameString).toCharArray();
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        info.setHandle(handle);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSuperclassName(superclass);
        info.setSuperInterfaceNames(superinterfaces);
        info.setEnclosingTypeName(enclosingTypeName);
        info.setSourceFileName(this.fSourceFileName);
        info.setPackageName(this.fPackageName);
        info.setQualifiedName(qualifiedName);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitClass(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitCompilationUnit(int declarationEnd) {
        this.unitInfo.setSourceLength(declarationEnd + 1);
        this.unitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        int length;
        Object typeInfo;
        int flags;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        if (initializationStart != -1 && (Flags.isStatic(flags = info.flags) && Flags.isFinal(flags) || (typeInfo = this.infoStack.peek()) instanceof SourceTypeElementInfo && Flags.isInterface(((SourceTypeElementInfo)typeInfo).flags)) && (length = declarationEnd - initializationStart) > 0) {
            char[] initializer = new char[length];
            System.arraycopy(this.parser.scanner.source, initializationStart, initializer, 0, length);
            info.initializationSource = initializer;
        }
        this.handleStack.pop();
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitInterface(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.handleStack.pop();
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(IJavaElement handle) {
        while (this.newElements.containsKey(handle)) {
            JavaElement h = (JavaElement)handle;
            h.setOccurrenceCount(h.getOccurrenceCount() + 1);
        }
    }
}

