/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.InitializationFlowContext;
import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.parser.UnitParser;
import net.sourceforge.phpdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public static final int FUNCTION_DEFINITION = 1;
    public static final int METHOD_DEFINITION = 2;
    public int type;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding returnType;
            if (this.binding == null) {
                return;
            }
            if (this.binding.isPrivate() && !this.binding.isPrivateUsed() && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.isAbstract()) {
                return;
            }
            ExceptionHandlingFlowContext methodContext = new ExceptionHandlingFlowContext(initializationContext, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int i = 0;
                int count = this.statements.length;
                while (i < count) {
                    Statement stat = this.statements[i];
                    if (!flowInfo.complainIfUnreachable(stat, this.scope, didAlreadyComplain)) {
                        flowInfo = stat.analyseCode(this.scope, methodContext, flowInfo);
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i;
                }
            }
            if ((returnType = this.binding.returnType) == VoidBinding || this.isAbstract()) {
                this.needFreeReturn = flowInfo.isReachable();
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(returnType, this);
            }
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void parseStatements(UnitParser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, unit);
    }

    public void resolveStatements() {
        if (this.returnType != null && this.binding != null) {
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (this.binding != null && this.isTypeUseDeprecated(this.binding.returnType, this.scope)) {
            this.scope.problemReporter().deprecatedType(this.binding.returnType, this.returnType);
        }
        if (this.scope != null) {
            if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
                this.scope.problemReporter().methodWithConstructorName(this);
            }
            this.scope.enclosingSourceType().isInterface();
        }
        super.resolveStatements();
    }

    public String returnTypeToString(int tab) {
        if (this.returnType == null) {
            return "";
        }
        return String.valueOf(this.returnType.toString(tab)) + " ";
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.returnType != null) {
                this.returnType.traverse(visitor, this.scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i = 0;
                while (i < thrownExceptionsLength) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }
}

