/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorExpression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;

public class ConditionalExpression
extends OperatorExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    private int returnTypeSlotSize = 1;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ConditionalExpression(Expression condition, Expression valueIfTrue, Expression valueIfFalse) {
        this.condition = condition;
        this.valueIfTrue = valueIfTrue;
        this.valueIfFalse = valueIfFalse;
        this.sourceStart = condition.sourceStart;
        this.sourceEnd = valueIfFalse.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo mergedInfo;
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != NotAConstant && !cst.booleanValue();
        int mode = flowInfo.reachMode();
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo, cst == NotAConstant);
        FlowInfo trueFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            trueFlowInfo.setReachMode(1);
        }
        this.trueInitStateIndex = currentScope.methodScope().recordInitializationStates(trueFlowInfo);
        trueFlowInfo = this.valueIfTrue.analyseCode(currentScope, flowContext, trueFlowInfo);
        FlowInfo falseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            falseFlowInfo.setReachMode(1);
        }
        this.falseInitStateIndex = currentScope.methodScope().recordInitializationStates(falseFlowInfo);
        falseFlowInfo = this.valueIfFalse.analyseCode(currentScope, flowContext, falseFlowInfo);
        if (isConditionOptimizedTrue) {
            mergedInfo = trueFlowInfo.addPotentialInitializationsFrom(falseFlowInfo);
        } else if (isConditionOptimizedFalse) {
            mergedInfo = falseFlowInfo.addPotentialInitializationsFrom(trueFlowInfo);
        } else {
            cst = this.optimizedIfTrueConstant;
            boolean isValueIfTrueOptimizedTrue = cst != null && cst != NotAConstant && cst.booleanValue();
            boolean isValueIfTrueOptimizedFalse = cst != null && cst != NotAConstant && !cst.booleanValue();
            cst = this.optimizedIfFalseConstant;
            boolean isValueIfFalseOptimizedTrue = cst != null && cst != NotAConstant && cst.booleanValue();
            boolean isValueIfFalseOptimizedFalse = cst != null && cst != NotAConstant && !cst.booleanValue();
            UnconditionalFlowInfo trueInfoWhenTrue = trueFlowInfo.initsWhenTrue().copy().unconditionalInits();
            if (isValueIfTrueOptimizedFalse) {
                trueInfoWhenTrue.setReachMode(1);
            }
            UnconditionalFlowInfo falseInfoWhenTrue = falseFlowInfo.initsWhenTrue().copy().unconditionalInits();
            if (isValueIfFalseOptimizedFalse) {
                falseInfoWhenTrue.setReachMode(1);
            }
            UnconditionalFlowInfo trueInfoWhenFalse = trueFlowInfo.initsWhenFalse().copy().unconditionalInits();
            if (isValueIfTrueOptimizedTrue) {
                trueInfoWhenFalse.setReachMode(1);
            }
            UnconditionalFlowInfo falseInfoWhenFalse = falseFlowInfo.initsWhenFalse().copy().unconditionalInits();
            if (isValueIfFalseOptimizedTrue) {
                falseInfoWhenFalse.setReachMode(1);
            }
            mergedInfo = FlowInfo.conditional(trueInfoWhenTrue.mergedWith(falseInfoWhenTrue), trueInfoWhenFalse.mergedWith(falseInfoWhenFalse));
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        mergedInfo.setReachMode(mode);
        return mergedInfo;
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.condition.printExpression(indent, output).append(" ? ");
        this.valueIfTrue.printExpression(0, output).append(" : ");
        return this.valueIfFalse.printExpression(0, output);
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.condition.toStringExpression()) + " ? " + this.valueIfTrue.toStringExpression() + " : " + this.valueIfFalse.toStringExpression();
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.valueIfTrue.traverse(visitor, scope);
            this.valueIfFalse.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

