/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.ImportReference;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.impl.ReferenceContext;
import net.sourceforge.phpdt.internal.compiler.lookup.CompilationUnitScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalTypeBinding;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilationUnit;
import net.sourceforge.phpdt.internal.compiler.problem.AbortMethod;
import net.sourceforge.phpdt.internal.compiler.problem.AbortType;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemReporter;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemSeverities;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public ArrayList types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    private LocalTypeBinding[] localTypes;
    int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.types = new ArrayList();
        this.sourceStart = 0;
        this.sourceEnd = sourceLength - 1;
    }

    public void abort(int abortLevel) {
        switch (abortLevel) {
            case 8: {
                throw new AbortType(this.compilationResult);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int i = 0;
                int count = this.types.size();
                while (i < count) {
                    if (this.types.get(i) instanceof TypeDeclaration) {
                        ((TypeDeclaration)this.types.get(i)).analyseCode(this.scope);
                    }
                    ++i;
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        if (this.types != null) {
            int i = 0;
            int max = this.types.size();
            while (i < max) {
                if (this.types.get(i) instanceof TypeDeclaration) {
                    this.cleanUp((TypeDeclaration)this.types.get(i));
                }
                ++i;
            }
            i = 0;
            max = this.localTypeCount;
            while (i < max) {
                this.localTypes[i].scope = null;
                ++i;
            }
        }
    }

    private void cleanUp(TypeDeclaration type) {
        if (type.memberTypes != null) {
            int i = 0;
            int max = type.memberTypes.length;
            while (i < max) {
                this.cleanUp(type.memberTypes[i]);
                ++i;
            }
        }
        if (type.binding != null) {
            type.binding.scope = null;
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        int i = 0;
        while (i < this.types.size()) {
            TypeDeclaration typeDecl;
            if (this.types.get(i) instanceof TypeDeclaration && (typeDecl = ((TypeDeclaration)this.types.get(i)).declarationOfType(typeName)) != null) {
                return typeDecl;
            }
            ++i;
        }
        return null;
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int end;
            char[] fileName = this.compilationResult.getFileName();
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(indent, output).append("package ");
            this.currentPackage.print(0, output, false).append(";\n");
        }
        if (this.imports != null) {
            i = 0;
            while (i < this.imports.length) {
                CompilationUnitDeclaration.printIndent(indent, output).append("import ");
                this.imports[i].print(0, output).append(";\n");
                ++i;
            }
        }
        if (this.types != null) {
            i = 0;
            while (i < this.types.size()) {
                ((ASTNode)this.types.get(i)).print(indent, output).append("\n");
                ++i;
            }
        }
        return output;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int i = 0;
        int max = this.localTypeCount;
        while (i < max) {
            LocalTypeBinding localType = this.localTypes[i];
            if ((localType.scope.referenceType().bits & Integer.MIN_VALUE) != 0) {
                localType.updateInnerEmulationDependents();
            }
            ++i;
        }
    }

    public void record(LocalTypeBinding localType) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localType;
    }

    public void resolve() {
        try {
            if (this.types != null) {
                int i = 0;
                int count = this.types.size();
                while (i < count) {
                    if (this.types.get(i) instanceof TypeDeclaration) {
                        ((TypeDeclaration)this.types.get(i)).resolve(this.scope);
                    }
                    ++i;
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public String toString(int tab) {
        int i;
        String s = "";
        if (this.currentPackage != null) {
            s = String.valueOf(CompilationUnitDeclaration.tabString(tab)) + "package " + this.currentPackage.toString(0, false) + ";\n";
        }
        if (this.imports != null) {
            i = 0;
            while (i < this.imports.length) {
                s = String.valueOf(s) + CompilationUnitDeclaration.tabString(tab) + "include " + this.imports[i].toString() + ";\n";
                ++i;
            }
        }
        if (this.types != null) {
            i = 0;
            while (i < this.types.size()) {
                s = String.valueOf(s) + ((ASTNode)this.types.get(i)).toString(tab) + "\n";
                ++i;
            }
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, scope)) {
                int i;
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(visitor, scope);
                }
                if (this.imports != null) {
                    int importLength = this.imports.length;
                    i = 0;
                    while (i < importLength) {
                        this.imports[i].traverse(visitor, scope);
                        ++i;
                    }
                }
                if (this.types != null) {
                    int typesLength = this.types.size();
                    i = 0;
                    while (i < typesLength) {
                        if (this.types.get(i) instanceof TypeDeclaration) {
                            ((TypeDeclaration)this.types.get(i)).traverse(visitor, scope);
                        }
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }
}

