/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.core.internal.model;

import net.sourceforge.phpeclipse.core.model.SourceReference;
import net.sourceforge.phpeclipse.xml.core.internal.parser.XMLParser;
import net.sourceforge.phpeclipse.xml.core.model.IXMLDocument;
import net.sourceforge.phpeclipse.xml.core.model.IXMLElement;
import net.sourceforge.phpeclipse.xml.core.parser.IProblemCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class XMLDocument
extends SourceReference
implements IXMLDocument,
IDocumentListener {
    private IXMLElement root;
    private String systemId;
    private Object dirtyLock = new Object();
    private boolean dirty = true;

    public XMLDocument(IDocument document, String systemId) {
        super(document, 0, document.getLength());
        this.systemId = systemId;
    }

    public IXMLElement getRoot() {
        return this.root;
    }

    public String getSystemId() {
        return this.systemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(IProblemCollector problemCollector, IFile file) {
        Object object = this.dirtyLock;
        synchronized (object) {
            if (!this.dirty) {
                return;
            }
            this.dirty = false;
        }
        object = this;
        synchronized (object) {
            boolean doParse = false;
            this.root = null;
            if (file != null) {
                String filename = file.getFullPath().toString();
                int len = filename.length();
                if (len >= 4) {
                    if ((filename.charAt(len - 1) != 'l' && filename.charAt(len - 1) != 'L' || filename.charAt(len - 2) != 'p' && filename.charAt(len - 2) != 'P' || filename.charAt(len - 3) != 't' && filename.charAt(len - 3) != 'T' || filename.charAt(len - 4) != '.') && (filename.charAt(len - 1) != 'm' && filename.charAt(len - 1) != 'M' || filename.charAt(len - 2) != 't' && filename.charAt(len - 2) != 'T' || filename.charAt(len - 3) != 'h' && filename.charAt(len - 3) != 'H' || filename.charAt(len - 4) != '.') && len >= 5 && (filename.charAt(len - 1) != 'l' && filename.charAt(len - 1) != 'L' || filename.charAt(len - 2) != 'm' && filename.charAt(len - 2) != 'M' || filename.charAt(len - 3) != 't' && filename.charAt(len - 3) != 'T' || filename.charAt(len - 4) != 'h' && filename.charAt(len - 4) != 'H' || filename.charAt(len - 5) != '.')) {
                        doParse = true;
                    }
                } else {
                    doParse = true;
                }
            }
            if (doParse) {
                XMLParser parser = new XMLParser();
                parser.setProblemCollector(problemCollector);
                parser.setSource(this.getDocument());
                parser.setSystemId(this.systemId);
                IXMLDocument model = parser.parse();
                if (model != null) {
                    this.root = model.getRoot();
                }
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(DocumentEvent event) {
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirty = true;
        }
    }

    public void setRoot(IXMLElement root) {
        this.root = root;
    }
}

