/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ExecutionArguments {
    protected static final QualifiedName EXECUTION_ARGUMENTS_PROPERTY = new QualifiedName("net.sourceforge.phpdt", "executionArguments");
    protected static final String ARGUMENT_SEPARATOR = "**<ArgBreak>**";
    protected String interpreterArguments;
    protected String phpFileArguments;

    public static ExecutionArguments getExecutionArguments(IFile phpScriptFile) {
        try {
            String executionArgumentsPersistableFormat = phpScriptFile.getPersistentProperty(EXECUTION_ARGUMENTS_PROPERTY);
            ExecutionArguments executionArguments = new ExecutionArguments();
            if (executionArgumentsPersistableFormat != null) {
                int argBreakIndex = executionArgumentsPersistableFormat.indexOf(ARGUMENT_SEPARATOR);
                executionArguments.setInterpreterArguments(executionArgumentsPersistableFormat.substring(0, argBreakIndex));
                executionArguments.setPHPFileArguments(executionArgumentsPersistableFormat.substring(argBreakIndex + ARGUMENT_SEPARATOR.length()));
            }
            return executionArguments;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void setExecutionArguments(IFile phpScriptFile, ExecutionArguments arguments) {
        try {
            phpScriptFile.setPersistentProperty(EXECUTION_ARGUMENTS_PROPERTY, arguments.toPersistableFormat());
        }
        catch (CoreException coreException) {}
    }

    public void setInterpreterArguments(String theArguments) {
        this.interpreterArguments = theArguments;
    }

    public void setPHPFileArguments(String theArguments) {
        this.phpFileArguments = theArguments;
    }

    public String toPersistableFormat() {
        return String.valueOf(this.interpreterArguments) + ARGUMENT_SEPARATOR + this.phpFileArguments;
    }
}

