/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.php.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XDebugTab
extends AbstractLaunchConfigurationTab {
    private Label fPortLabel;
    private Button fUseDefaultPortButton;
    private Text fPortText;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createDebugPortEditor(comp);
    }

    private void createDebugPortEditor(Composite parent) {
        Font font = parent.getFont();
        Group debugGroup = new Group(parent, 0);
        debugGroup.setText("Debug: ");
        GridData gd = new GridData(768);
        debugGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        debugGroup.setLayout((Layout)layout);
        debugGroup.setFont(font);
        this.fPortLabel = new Label((Composite)debugGroup, 0);
        this.fPortLabel.setText("&DebugPort:");
        this.fPortLabel.setFont(font);
        this.fPortText = new Text((Composite)debugGroup, 2052);
        gd = new GridData(768);
        this.fPortText.setLayoutData((Object)gd);
        this.fPortText.setFont(font);
        this.fPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                XDebugTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fUseDefaultPortButton = new Button((Composite)debugGroup, 32);
        this.fUseDefaultPortButton.setText("Use default interpreter");
        gd = new GridData(768);
        this.fUseDefaultPortButton.setLayoutData((Object)gd);
        this.fUseDefaultPortButton.setFont(font);
        this.fUseDefaultPortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                XDebugTab.this.handleDefaultSellected(event);
            }
        });
    }

    protected void setDebugportEnabledState() {
        if (this.isDefaultInterpreter()) {
            this.fPortText.setEnabled(false);
            this.fPortLabel.setEnabled(false);
        } else {
            this.fPortText.setEnabled(true);
            this.fPortLabel.setEnabled(true);
        }
    }

    protected boolean isDefaultInterpreter() {
        return this.fUseDefaultPortButton.getSelection();
    }

    protected void handleDefaultSellected(SelectionEvent event) {
        this.setDebugportEnabledState();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String portText = "" + configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEBUGPORT", 9000);
            this.fPortText.setText(portText);
            boolean selection = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEFAULT_DEBUGPORT", true);
            this.fUseDefaultPortButton.setSelection(selection);
            this.setDebugportEnabledState();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEFAULT_DEBUGPORT", this.fUseDefaultPortButton.getSelection());
        try {
            configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEBUGPORT", Integer.parseInt(this.fPortText.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            Integer.parseInt(this.fPortText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Debugport is not a valid integer");
            return false;
        }
        return true;
    }

    public String getName() {
        return "XDebug";
    }
}

