/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;

public class XDebugLineBreakpoint
extends XDebugBreakpoint
implements ILineBreakpoint {
    private static final String XDEBUG_LINE_BREAKPOINT = "net.sourceforge.phpeclipse.xdebug.core.XDebugLineBreakpoint";
    protected static final String TYPE_NAME = "net.sourceforge.phpeclipse.debug.typeName";
    public static final String BREAKPOINT_ID = "XDebugLineBreakpointID";

    public XDebugLineBreakpoint() {
    }

    public XDebugLineBreakpoint(final IResource resource, final int lineNumber) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                XDebugLineBreakpoint.this.setMarker(resource.createMarker(XDebugLineBreakpoint.XDEBUG_LINE_BREAKPOINT));
                HashMap attributes = new HashMap(10);
                XDebugLineBreakpoint.this.addLineBreakpointAttributes(attributes, XDebugLineBreakpoint.this.getModelIdentifier(), true, lineNumber, -1, -1);
                XDebugLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                XDebugLineBreakpoint.this.register(true);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public void addLineBreakpointAttributes(Map attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("lineNumber", new Integer(lineNumber));
        if (charStart != -1) {
            attributes.put("charStart", new Integer(charStart));
            attributes.put("charEnd", new Integer(charEnd));
        }
        attributes.put(TYPE_NAME, "typeName");
        attributes.put(BREAKPOINT_ID, new Integer(-1));
    }

    public String getModelIdentifier() {
        return "net.sourceforge.phpeclipse.xdebug.php";
    }

    public void setID(int id) throws CoreException {
        this.ensureMarker().setAttribute(BREAKPOINT_ID, id);
    }

    public int getID() throws CoreException {
        return this.ensureMarker().getAttribute(BREAKPOINT_ID, -1);
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute("net.sourceforge.phpeclipse.xdebug.php.model.hitCount", -1);
    }

    public void setHitCount(int newHitCount) throws CoreException {
        this.ensureMarker().setAttribute("net.sourceforge.phpeclipse.xdebug.php.model.hitCount", newHitCount);
    }

    public int getLineNumber() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("lineNumber", -1);
        }
        return -1;
    }

    public int getCharStart() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("charStart", -1);
        }
        return -1;
    }

    public int getCharEnd() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("charEnd", -1);
        }
        return -1;
    }
}

