/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;
import net.sourceforge.phpeclipse.xdebug.core.XDebugProxy;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public class PHPLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] envp;
        String fileName;
        IFile file;
        File exe;
        ArrayList<String> commandList = new ArrayList<String>();
        String phpInterpreter = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_INTERPRETER", null);
        boolean useDefaultInterpreter = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEFAULT_INTERPRETER", true);
        if (useDefaultInterpreter && (phpInterpreter = XDebugCorePlugin.getDefault().getPreferenceStore().getString("phpInterpreter")) == "") {
            phpInterpreter = ExternalToolsPlugin.getDefault().getPreferenceStore().getString("_php_run_pref");
        }
        if (!(exe = new File(phpInterpreter)).exists()) {
            this.abort(MessageFormat.format("Specified PHP executable {0} does not exist. Check value of PHP-Interpreter.", phpInterpreter), null);
        }
        commandList.add(phpInterpreter);
        String projectName = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            this.abort("Project does not exist.", null);
        }
        if (!(file = project.getFile(fileName = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_FILE", null))).exists()) {
            this.abort(MessageFormat.format("PHP-Script {0} does not exist.", file.getFullPath().toString()), null);
        }
        commandList.add(file.getLocation().toOSString());
        int debugPort = XDebugCorePlugin.getDefault().getPreferenceStore().getInt("debugport");
        if (debugPort == 0) {
            debugPort = 9000;
        }
        if ((envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration)) == null) {
            Map stringVars = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironment();
            int idx = 0;
            envp = new String[stringVars.size()];
            Iterator i = stringVars.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)stringVars.get(key);
                envp[idx++] = String.valueOf(key) + "=" + value;
            }
        }
        String idekey = String.valueOf(fileName) + "-" + (int)(Math.random() * 100000.0);
        if (mode.equals("debug")) {
            String[] env = new String[envp.length + 1];
            int i = 0;
            while (i < envp.length) {
                env[i + 1] = envp[i];
                ++i;
            }
            env[0] = "XDEBUG_CONFIG=idekey=" + idekey + " remote_enable=1 remote_port=" + debugPort;
            envp = env;
        }
        System.out.println("ideKey= " + idekey);
        String[] commandLine = commandList.toArray(new String[commandList.size()]);
        XDebugProxy proxy = XDebugCorePlugin.getDefault().getXDebugProxy();
        proxy.start();
        XDebugTarget target = null;
        if (mode.equals("debug")) {
            target = new XDebugTarget(launch, null, idekey);
            proxy.addProxyEventListener(target, idekey);
        }
        Process process = DebugPlugin.exec((String[])commandLine, null, (String[])envp);
        IProcess p = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)phpInterpreter);
        if (mode.equals("debug")) {
            target.addProcess(p);
            launch.addDebugTarget((IDebugTarget)target);
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse.xdebug.php", 0, message, e));
    }
}

