/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.core.xdebug;

import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.ResponseList;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.XDebugConnection;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.XDebugResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;

public class ResponseListener
extends Job {
    private XDebugConnection fConnection;
    private ResponseList fResponseList;

    public ResponseListener(XDebugConnection connection) {
        super("XDebug Event Dispatch");
        this.setSystem(true);
        this.fConnection = connection;
        this.fResponseList = new ResponseList();
    }

    private void checkResponse(XDebugResponse response) {
        if (response.getStatus().equals("stopping") || response.getStatus().equals("stopped")) {
            this.cancel();
            this.fireEvent(2, null);
        } else if (response.getStatus().equals("break") && response.getReason().equals("ok")) {
            if (response.getCommand().equals("run")) {
                this.fireEvent(0, null);
            } else if (response.getCommand().equals("step_into")) {
                this.fireEvent(1, null);
            } else if (response.getCommand().equals("step_over")) {
                this.fireEvent(1, null);
            } else if (response.getCommand().equals("step_out")) {
                this.fireEvent(1, null);
            }
        }
    }

    private void fireEvent(int detail, Object data) {
        DebugEvent event = new DebugEvent((Object)this, 32, detail);
        event.setData(data);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected IStatus run(IProgressMonitor monitor) {
        String InputXML = "";
        while (!this.fConnection.isClosed()) {
            if (monitor.isCanceled()) continue;
            try {
                InputXML = this.fConnection.readData();
            }
            catch (Exception exception) {}
            if (InputXML == null) continue;
            XDebugCorePlugin.log(1, InputXML);
            XDebugResponse response = new XDebugResponse(InputXML);
            if (response.getName() != "response") continue;
            this.fResponseList.add(response);
            this.checkResponse(response);
        }
        return Status.OK_STATUS;
    }

    public XDebugResponse getResponse(int id) {
        return this.fResponseList.get(id);
    }
}

