/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.core;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import net.sourceforge.phpeclipse.xdebug.core.IProxyEventListener;
import net.sourceforge.phpeclipse.xdebug.core.ListenerMap;
import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.XDebugConnection;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.SafeRunnable;

public class XDebugProxy {
    private XDebugConnection fConnection;
    private ServerSocket fProxyServerSocket;
    private ProxyListenerJob fProxyListener;
    private boolean fTerminate;
    private int fProxyPort;
    private ListenerMap fEventListeners;
    private boolean fIsRunning;

    public XDebugProxy(int port) {
        this.fProxyPort = port;
    }

    public void start() {
        if (!this.fIsRunning) {
            try {
                this.fProxyServerSocket = new ServerSocket(this.fProxyPort);
                XDebugCorePlugin.log(1, "Proxy listens on port " + this.fProxyPort);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.fTerminate = false;
            this.fProxyListener = new ProxyListenerJob();
            this.fProxyListener.schedule();
            this.fIsRunning = true;
        }
    }

    public void stop() {
        if (this.fIsRunning) {
            this.fProxyListener.cancel();
            this.fTerminate = true;
            try {
                this.fProxyServerSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.fIsRunning = false;
            XDebugCorePlugin.log(1, "Proxy stopped");
        }
    }

    public void addProxyEventListener(IProxyEventListener listener, String key) {
        if (this.fEventListeners == null) {
            this.fEventListeners = new ListenerMap(5);
        }
        this.fEventListeners.add(listener, key);
    }

    public void removeProxyEventListener(IProxyEventListener listener, String key) {
        if (this.fEventListeners != null) {
            this.fEventListeners.remove(listener, key);
            if (this.fEventListeners.size() == 0) {
                this.stop();
            }
        }
    }

    public void fireProxyEvent(String id) {
        EventNotifier fNotifier = new EventNotifier();
        fNotifier.dispatch(id);
    }

    private Object getEventListener(String ideKey) {
        return this.fEventListeners.getListener(ideKey);
    }

    public int getProxyPort() {
        return this.fProxyPort;
    }

    class EventNotifier
    implements ISafeRunnable {
        private IProxyEventListener fListener;

        EventNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, XDebugCorePlugin.getUniqueIdentifier(), 4, "An exception occurred while dispatching proxy", exception);
            XDebugCorePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fListener.handleProxyEvent(XDebugProxy.this.fConnection);
        }

        public void dispatch(String id) {
            this.fListener = (IProxyEventListener)XDebugProxy.this.getEventListener(id);
            SafeRunnable.run((ISafeRunnable)this);
            this.fListener = null;
        }
    }

    class ProxyListenerJob
    extends Job {
        public ProxyListenerJob() {
            super("XDebug Proxy Connection Dispatch");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Socket socket = null;
            while (!XDebugProxy.this.fTerminate) {
                boolean error = false;
                socket = null;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    socket = XDebugProxy.this.fProxyServerSocket.accept();
                }
                catch (IOException iOException) {
                    error = true;
                }
                if (error) continue;
                XDebugCorePlugin.log(1, "Proxy: someone tries to connect");
                XDebugProxy.this.fConnection = new XDebugConnection(socket);
                if (!XDebugProxy.this.fConnection.isInitialized()) continue;
                String IdeKey = XDebugProxy.this.fConnection.getSessionID();
                Object a = XDebugProxy.this.getEventListener(IdeKey);
                if (a instanceof XDebugTarget) {
                    XDebugCorePlugin.log(1, "<init idekey \"" + IdeKey + "\">");
                    XDebugProxy.this.fireProxyEvent(IdeKey);
                    continue;
                }
                XDebugProxy.this.fConnection.close();
                XDebugProxy.this.fConnection = null;
            }
            return Status.OK_STATUS;
        }
    }
}

