/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.core;

import java.util.HashMap;

public class ListenerMap {
    private int fSize;
    private HashMap fListeners = null;

    public ListenerMap(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.fListeners = new HashMap(capacity);
        this.fSize = 0;
    }

    public synchronized void add(Object listener, String ideKey) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.fListeners.get(ideKey) == null) {
            ++this.fSize;
        }
        this.fListeners.put(ideKey, listener);
    }

    public synchronized HashMap getListeners() {
        if (this.fSize == 0) {
            return null;
        }
        HashMap result = new HashMap(this.fListeners);
        return result;
    }

    public synchronized Object getListener(String ideKey) {
        return this.fListeners.get(ideKey);
    }

    public synchronized void remove(Object listener, String ideKey) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.fListeners.get(ideKey) == listener) {
            this.fListeners.remove(ideKey);
            --this.fSize;
        }
    }

    public synchronized void removeAll() {
        this.fListeners.clear();
        this.fSize = 0;
    }

    public int size() {
        return this.fSize;
    }
}

