/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.views.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private Point size = null;
    private ImageDescriptor base;
    private ImageDescriptor[][] overlays;

    public OverlayImageDescriptor(ImageDescriptor base, ImageDescriptor[][] overlays) {
        this(base, overlays, null);
    }

    public OverlayImageDescriptor(ImageDescriptor base, ImageDescriptor[][] overlays, Point size) {
        this.base = base;
        this.overlays = overlays;
        if (size == null) {
            ImageData data = base.getImageData();
            size = new Point(data.width, data.height);
        }
        this.size = size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg;
        if (this.base == null || (bg = this.base.getImageData()) == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        if (this.overlays != null) {
            if (this.overlays.length > 0) {
                this.drawTopRight(this.overlays[0]);
            }
            if (this.overlays.length > 1) {
                this.drawBottomRight(this.overlays[1]);
            }
            if (this.overlays.length > 2) {
                this.drawBottomLeft(this.overlays[2]);
            }
            if (this.overlays.length > 3) {
                this.drawTopLeft(this.overlays[3]);
            }
        }
    }

    protected Point getSize() {
        return this.size;
    }

    private void drawBottomLeft(ImageDescriptor[] descriptors) {
        if (descriptors == null) {
            return;
        }
        int length = descriptors.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && descriptors[i] != null) {
                ImageData id = descriptors[i].getImageData();
                this.drawImage(id, x, this.getSize().y - id.height);
                x += id.width;
            }
            ++i;
        }
    }

    private void drawBottomRight(ImageDescriptor[] descriptors) {
        if (descriptors == null) {
            return;
        }
        int length = descriptors.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && descriptors[i] != null) {
                ImageData id = descriptors[i].getImageData();
                this.drawImage(id, x -= id.width, this.getSize().y - id.height);
            }
            --i;
        }
    }

    private void drawTopLeft(ImageDescriptor[] descriptors) {
        if (descriptors == null) {
            return;
        }
        int length = descriptors.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && descriptors[i] != null) {
                ImageData id = descriptors[i].getImageData();
                this.drawImage(id, x, 0);
                x += id.width;
            }
            ++i;
        }
    }

    private void drawTopRight(ImageDescriptor[] descriptors) {
        if (descriptors == null) {
            return;
        }
        int length = descriptors.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && descriptors[i] != null) {
                ImageData id = descriptors[i].getImageData();
                this.drawImage(id, x -= id.width, 0);
            }
            --i;
        }
    }
}

