/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.internal.ui;

import java.util.ArrayList;
import net.sourceforge.phpdt.externaltools.internal.ui.TreeAndListGroup;
import net.sourceforge.phpdt.externaltools.model.StringMatcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionDialog
extends MessageDialog {
    private IAdaptable root;
    private TreeAndListGroup selectionGroup;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private IFile result = null;
    private StringMatcher stringMatcher = null;

    public FileSelectionDialog(Shell parentShell, IAdaptable rootElement, String message) {
        super(parentShell, "Add Build File", null, message, 0, new String[]{"Ok", "Cancel"}, 0);
        this.root = rootElement;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setFileFilter(String pattern, boolean ignoreCase) {
        this.stringMatcher = pattern != null ? new StringMatcher(pattern, ignoreCase, false) : null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.selectionGroup = new TreeAndListGroup(composite, this.root, this.getResourceProvider(14), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), (ILabelProvider)new WorkbenchLabelProvider(), 0, 400, 300);
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = FileSelectionDialog.this.selectionGroup.getListTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].pack();
                    ++i;
                }
            }
        });
        return composite;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    int i;
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                        ArrayList<IResource> accessibleMembers = new ArrayList<IResource>(members.length);
                        i = 0;
                        while (i < members.length) {
                            IResource resource = members[i];
                            if (resource.isAccessible()) {
                                accessibleMembers.add(resource);
                            }
                            ++i;
                        }
                        members = accessibleMembers.toArray(new IResource[accessibleMembers.size()]);
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0 && (members[i].getType() != 1 || FileSelectionDialog.this.stringMatcher == null || FileSelectionDialog.this.stringMatcher.match(members[i].getName()))) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        this.selectionGroup.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileSelectionDialog.this.getOkButton().setEnabled(!FileSelectionDialog.this.selectionGroup.getListTableSelection().isEmpty());
            }
        });
        this.getOkButton().setEnabled(false);
    }

    protected Button getOkButton() {
        return this.getButton(0);
    }

    public IFile getResult() {
        return this.result;
    }

    protected void buttonPressed(int buttonId) {
        Object resource;
        if (buttonId == 0 && (resource = this.selectionGroup.getListTableSelection().getFirstElement()) instanceof IFile) {
            this.result = (IFile)resource;
        }
        super.buttonPressed(buttonId);
    }
}

