/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.internal.registry;

import net.sourceforge.phpdt.externaltools.group.IGroupDialogPage;
import net.sourceforge.phpdt.externaltools.internal.model.ExternalToolsModelMessages;
import net.sourceforge.phpdt.externaltools.variable.IVariableComponent;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public abstract class ExternalToolVariable {
    private static final IVariableComponent defaultComponent = new DefaultVariableComponent(false);
    private String tag;
    private String description;
    private IConfigurationElement element;

    ExternalToolVariable(String tag, String description, IConfigurationElement element) {
        this.tag = tag;
        this.description = description;
        this.element = element;
    }

    protected final Object createObject(String attributeName) {
        try {
            return this.element.createExecutableExtension(attributeName);
        }
        catch (CoreException e) {
            ExternalToolsPlugin.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }

    public final IVariableComponent getComponent() {
        String className = this.element.getAttribute("componentClass");
        if (className == null || className.trim().length() == 0) {
            return defaultComponent;
        }
        Object component = this.createObject("componentClass");
        if (component == null) {
            return new DefaultVariableComponent(true);
        }
        return (IVariableComponent)component;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getTag() {
        return this.tag;
    }

    private static final class DefaultVariableComponent
    implements IVariableComponent {
        private boolean showError = false;
        private Label message = null;

        public DefaultVariableComponent(boolean showError) {
            this.showError = showError;
        }

        public Control getControl() {
            return this.message;
        }

        public void createContents(Composite parent, String varTag, IGroupDialogPage page) {
            if (this.showError) {
                this.message = new Label(parent, 0);
                GridData data = new GridData(256);
                this.message.setLayoutData((Object)data);
                this.message.setFont(parent.getFont());
                this.message.setText(ExternalToolsModelMessages.getString("ExternalToolVariable.componentErrorMessage"));
                this.message.setForeground(JFaceColors.getErrorText((Display)this.message.getDisplay()));
            }
        }

        public String getVariableValue() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public void setVariableValue(String varValue) {
        }

        public void validate() {
        }
    }
}

