/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugElement;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugTarget;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPThread
extends PHPDebugElement
implements IThread {
    private PHPStackFrame[] frames;
    private PHPDebugTarget target;
    private String name;
    private int id;
    private final State state = new State();
    static /* synthetic */ Class class$0;

    public PHPThread(PHPDebugTarget target, int id) {
        super(target);
        this.target = target;
        this.setId(id);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return ((PHPDebugTarget)this.getDebugTarget()).getStackFrames();
        }
        return new IStackFrame[0];
    }

    public int getStackFramesSize() {
        return this.frames.length;
    }

    public boolean hasStackFrames() {
        if (this.frames == null) {
            return false;
        }
        return this.frames.length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.frames == null || this.frames.length == 0) {
            return null;
        }
        return this.frames[0];
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public void setDebugTarget(PHPDebugTarget target) {
        this.target = target;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public synchronized boolean canResume() {
        return this.isSuspended();
    }

    public synchronized boolean canSuspend() {
        return !this.isSuspended();
    }

    public synchronized boolean isSuspended() {
        return this.state.isSuspended;
    }

    protected void prepareForResume(int de) {
        this.state.setSuspended(false);
        this.frames = null;
        DebugEvent ev = new DebugEvent((Object)this, 1, de);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    public synchronized void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        this.prepareForResume(2);
        ((PHPDebugTarget)this.getDebugTarget()).getPHPDBGProxy().resume();
    }

    public synchronized void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        this.state.setSuspended(true);
        this.state.setStepping(false);
        this.getDebugTarget().suspend();
        DebugEvent ev = new DebugEvent((Object)this, 2, 16);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    public boolean canStepInto() {
        return this.isSuspended() && this.isStepping() && this.hasStackFrames();
    }

    public boolean canStepOver() {
        return this.isSuspended() && this.isStepping() && this.hasStackFrames();
    }

    public boolean canStepReturn() {
        return this.isSuspended() && this.isStepping() && this.hasStackFrames();
    }

    public boolean isStepping() {
        return this.state.isStepping();
    }

    public void stepInto() throws DebugException {
        try {
            this.state.setStepping(true);
        }
        catch (IllegalStateException x) {
            throw new DebugException(PHPeclipsePlugin.error((Throwable)x));
        }
        this.frames = null;
        this.frames[0].stepInto();
    }

    public void stepOver() throws DebugException {
        this.state.setStepping(true);
        this.frames = null;
        this.frames[0].stepOver();
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.state.isTerminated();
    }

    public synchronized void terminate() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        this.state.setTerminated(true);
        this.frames = null;
        this.getDebugTarget().terminate();
        this.fireTerminateEvent();
    }

    public Object getAdapter(Class arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(arg0)) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    try {
                        return PHPThread.this.getStackFrames();
                    }
                    catch (DebugException x) {
                        PHPeclipsePlugin.log((String)"Unable to get stack frames.", (Throwable)x);
                        return new Object[0];
                    }
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return null;
                }

                public String getLabel(Object o) {
                    throw new UnsupportedOperationException();
                }

                public Object getParent(Object o) {
                    return PHPThread.this.getDebugTarget();
                }
            };
        }
        return super.getAdapter(arg0);
    }

    public void setStackFrames(PHPStackFrame[] frames) {
        this.frames = frames;
    }

    public String getName() {
        String name = this.name;
        if (this.isSuspended()) {
            name = String.valueOf(name) + " (suspended)";
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private class State {
        private boolean isSuspended = false;
        private boolean isTerminated = false;
        private boolean isStepping = false;

        private State() {
        }

        boolean isSuspended() {
            return this.isSuspended;
        }

        boolean isTerminated() {
            return this.isTerminated;
        }

        boolean isStepping() {
            return this.isStepping;
        }

        void setSuspended(boolean suspended) {
            if (this.isTerminated()) {
                throw new IllegalStateException();
            }
            if (suspended && this.isStepping()) {
                throw new IllegalStateException();
            }
            this.isSuspended = suspended;
        }

        void setStepping(boolean stepping) {
            if (stepping && !this.isSuspended()) {
                throw new IllegalStateException();
            }
            if (this.isTerminated()) {
                throw new IllegalStateException();
            }
            this.isStepping = stepping;
        }

        void setTerminated(boolean terminated) {
            this.isTerminated = terminated;
        }
    }
}

