/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGBase;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGFrame;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGMod;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGPacket;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGProxy;
import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDBGEvalString;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class PHPDBGInterface {
    public boolean sessionEnded = false;
    public int sessType = -1;
    public int BPUnderHit = 0;
    public String sessID = new String();
    private int[] LastBPRead = new int[10];
    private Vector DBGBPList = new Vector();
    private Vector DBGVarList = new Vector();
    private PHPStackFrame[] DBGStackList = new PHPStackFrame[0];
    private Vector DBGMods = new Vector();
    private Vector stackListOld = new Vector();
    private BufferedReader in;
    private OutputStream os;
    private boolean shouldStop = false;
    private String evalRet = new String("");
    private int rawCounter = 1000;
    private PHPDBGProxy proxy = null;
    private int lastCmd = -1;
    private int sid = 0;
    private boolean stopOnError = false;
    private char[] lastCommand = new char[4];
    private static final String GlobalVariablesTitle = PHPDebugCorePlugin.getResourceString("VariablesView.GlobalVariables.title");

    public PHPDBGInterface(BufferedReader in, OutputStream os, PHPDBGProxy proxy) {
        this.DBGBPList.clear();
        this.in = in;
        this.os = os;
        this.proxy = proxy;
    }

    public int addBreakpoint(String mod_name, int line, int hitCount, String condition) throws IOException {
        return this.setBreakpoint(mod_name, condition, line, 258, 0, hitCount, 0, 0, 0);
    }

    public void removeBreakpoint(String mod_name, int line, int bpNo) throws IOException {
        this.setBreakpoint(mod_name, "", line, 1, 0, 0, 0, bpNo, 0);
    }

    public void requestDBGVersion() throws IOException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame = new PHPDBGFrame(100800);
        DBGPacket.addFrame(DBGFrame);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
    }

    public void getSourceTree() throws IOException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame = new PHPDBGFrame(100200);
        DBGPacket.addFrame(DBGFrame);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
        this.waitResponse(1000L);
        this.flushAllPackets();
    }

    public void addDBGModName(String modName) throws IOException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame = new PHPDBGFrame(100300);
        ++this.rawCounter;
        DBGFrame.addInt(this.rawCounter);
        DBGFrame.addInt(modName.length() + 1);
        DBGFrame.addString(modName);
        DBGFrame.addChar('\u0000');
        DBGPacket.addFrame(DBGFrame);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
    }

    private int setBreakpoint(String mod_name, String condition, int line, int state, int istemp, int hitcount, int skiphits, int bpno, int isunderhit) throws IOException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame1 = new PHPDBGFrame(100600);
        PHPDBGFrame DBGFrame2 = new PHPDBGFrame(100300);
        PHPDBGFrame DBGFrame3 = new PHPDBGFrame(100300);
        int modNo = this.getModByName(mod_name);
        if (modNo >= 0) {
            DBGFrame1.addInt(modNo);
        } else {
            DBGFrame1.addInt(0);
        }
        DBGFrame1.addInt(line);
        if (modNo >= 0) {
            DBGFrame1.addInt(0);
        } else {
            ++this.rawCounter;
            DBGFrame1.addInt(this.rawCounter);
        }
        if (modNo < 0) {
            DBGFrame2.addInt(this.rawCounter);
            DBGFrame2.addInt(mod_name.length() + 1);
            DBGFrame2.addString(mod_name);
            DBGFrame2.addChar('\u0000');
            DBGPacket.addFrame(DBGFrame2);
        }
        DBGFrame1.addInt(state);
        DBGFrame1.addInt(istemp);
        DBGFrame1.addInt(0);
        DBGFrame1.addInt(hitcount);
        if (!condition.equals("")) {
            ++this.rawCounter;
            DBGFrame1.addInt(this.rawCounter);
            DBGFrame3.addInt(this.rawCounter);
            DBGFrame3.addInt(condition.length() + 1);
            DBGFrame3.addString(condition);
            DBGFrame3.addChar('\u0000');
            DBGPacket.addFrame(DBGFrame3);
        } else {
            DBGFrame1.addInt(0);
        }
        DBGFrame1.addInt(bpno);
        DBGFrame1.addInt(isunderhit);
        DBGPacket.addFrame(DBGFrame1);
        if (this.proxy.getSocket().isClosed()) {
            return 0;
        }
        DBGPacket.sendPacket(this.os);
        this.clearLastBP();
        this.waitResponse(1000L);
        this.flushAllPackets();
        return this.LastBPRead[8];
    }

    private void clearLastBP() {
        int i = 0;
        while (i < this.LastBPRead.length) {
            this.LastBPRead[i] = 0;
            ++i;
        }
    }

    private void copyToLastBP(int[] BPBody) {
        int i = 0;
        while (i < this.LastBPRead.length) {
            this.LastBPRead[i] = BPBody[i];
            ++i;
        }
    }

    public void continueExecution() throws IOException {
        this.BPUnderHit = 0;
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_CONTINUE);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
        this.lastCommand = PHPDBGBase.DBGA_CONTINUE;
    }

    public void pauseExecution() throws IOException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.IntToChar4(19));
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
    }

    private int getBPUnderHit() {
        int BPUnder = 0;
        int[] dbg_bpl_body = new int[10];
        int i = 0;
        while (i < this.DBGBPList.size()) {
            dbg_bpl_body = (int[])this.DBGBPList.get(i);
            if (dbg_bpl_body[9] == 1) {
                BPUnder = dbg_bpl_body[8];
            }
            ++i;
        }
        return BPUnder;
    }

    public int getLastCmd() {
        return this.lastCmd;
    }

    public int getSID() {
        return this.sid;
    }

    public void setLastCmd(int cmd) {
        this.lastCmd = cmd;
    }

    public void stepInto() throws IOException {
        this.BPUnderHit = 0;
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_STEPINTO);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
        this.lastCommand = PHPDBGBase.DBGA_STEPINTO;
    }

    public void stepOver() throws IOException {
        this.BPUnderHit = 0;
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_STEPOVER);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
        this.lastCommand = PHPDBGBase.DBGA_STEPOVER;
    }

    public void stepOut() throws IOException {
        this.BPUnderHit = 0;
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_STEPOUT);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
        this.lastCommand = PHPDBGBase.DBGA_STEPOUT;
    }

    public void stopExecution() throws IOException {
        this.BPUnderHit = 0;
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_STOP);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
    }

    public synchronized Vector getVariables(PHPStackFrame stack) throws IOException, DebugException {
        if (this.DBGStackList.length == 0) {
            this.DBGVarList.clear();
            return this.DBGVarList;
        }
        int global_scope_id = this.DBGStackList.length > 1 ? 2 : -1;
        Vector globalList = this.getVariables(this.DBGStackList[this.DBGStackList.length - 1], global_scope_id);
        if (!globalList.isEmpty()) {
            this.removeUnresolvedThisVar(globalList);
            PHPVariable var = (PHPVariable)globalList.get(0);
            var.setName(GlobalVariablesTitle);
            var.setModifiable(false);
        }
        int scopeID = stack.getScopeID();
        if (!(globalList.isEmpty() || this.DBGStackList.length != 1 && scopeID != 2)) {
            PHPVariable var = (PHPVariable)globalList.get(0);
            PHPValue val = (PHPValue)var.getValue();
            this.DBGVarList = val.getChildVariables();
            return this.DBGVarList;
        }
        if (scopeID == 1) {
            this.DBGVarList = this.getVariables(stack, 1);
        } else {
            this.DBGVarList.clear();
        }
        if (this.DBGVarList.size() > 0) {
            PHPVariable var = (PHPVariable)this.DBGVarList.get(0);
            PHPValue val = (PHPValue)var.getValue();
            if (var.getName().equals("")) {
                this.DBGVarList = val.getChildVariables();
            }
        }
        if (!globalList.isEmpty()) {
            this.DBGVarList.add(globalList.get(0));
        }
        return this.DBGVarList;
    }

    private Vector getVariables(PHPStackFrame stack, int scope_id) throws IOException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame1 = new PHPDBGFrame(100500);
        DBGFrame1.addInt(0);
        DBGFrame1.addInt(scope_id);
        DBGPacket.addFrame(DBGFrame1);
        this.evalRet = "";
        if (this.proxy.getSocket().isClosed()) {
            return new Vector();
        }
        DBGPacket.sendPacket(this.os);
        this.waitResponse(1000L);
        this.flushAllPackets();
        PHPDBGEvalString evalStr = new PHPDBGEvalString(stack, this.evalRet);
        return evalStr.getVariables();
    }

    private void removeUnresolvedThisVar(Vector varList) {
        if (varList.size() > 0) {
            PHPVariable var = (PHPVariable)varList.get(0);
            PHPValue val = (PHPValue)var.getValue();
            Vector workList = val.getChildVariables();
            int i = 0;
            while (i < workList.size()) {
                PHPVariable workvar = (PHPVariable)workList.get(i);
                if (workvar.getName().equals("$this")) {
                    String workval = ((PHPValue)workvar.getValue()).getValueString();
                    if (!workval.equals("?") && !workval.equals("NULL")) break;
                    workList.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void log(String logString) throws IOException, DebugException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame1 = new PHPDBGFrame(101200);
        PHPDBGFrame DBGFrame2 = new PHPDBGFrame(100300);
        ++this.rawCounter;
        DBGFrame1.addInt(this.rawCounter);
        DBGFrame1.addInt(1);
        DBGFrame1.addInt(0);
        DBGFrame1.addInt(0);
        DBGFrame1.addInt(0);
        DBGFrame1.addInt(0);
        DBGFrame2.addInt(this.rawCounter);
        DBGFrame2.addInt(logString.length() + 1);
        DBGFrame2.addString(logString);
        DBGFrame2.addChar('\u0000');
        DBGPacket.addFrame(DBGFrame2);
        DBGPacket.addFrame(DBGFrame1);
        if (this.proxy.getSocket().isClosed()) {
            return;
        }
        DBGPacket.sendPacket(this.os);
        this.waitResponse(1000L);
        this.flushAllPackets();
    }

    public synchronized PHPVariable[] evalBlock(PHPStackFrame stack, String evalString) throws IOException, DebugException {
        PHPDBGPacket DBGPacket = new PHPDBGPacket(PHPDBGBase.DBGA_REQUEST);
        PHPDBGFrame DBGFrame1 = new PHPDBGFrame(100500);
        PHPDBGFrame DBGFrame2 = new PHPDBGFrame(100300);
        ++this.rawCounter;
        DBGFrame1.addInt(this.rawCounter);
        int scope_id = stack.getScopeID();
        DBGFrame1.addInt(scope_id);
        DBGFrame2.addInt(this.rawCounter);
        DBGFrame2.addInt(evalString.length() + 1);
        DBGFrame2.addString(evalString);
        DBGFrame2.addChar('\u0000');
        DBGPacket.addFrame(DBGFrame2);
        DBGPacket.addFrame(DBGFrame1);
        if (this.proxy.getSocket().isClosed()) {
            return null;
        }
        DBGPacket.sendPacket(this.os);
        this.waitResponse(1000L);
        this.flushAllPackets();
        PHPDBGEvalString evalStr = new PHPDBGEvalString(stack, this.evalRet);
        return evalStr.getVars();
    }

    public void flushAllPackets() throws IOException {
        while (this.readResponse() != 0) {
        }
    }

    public String getModByNo(int modNo) {
        int i = 0;
        while (i < this.DBGMods.size()) {
            PHPDBGMod dbg_mod = (PHPDBGMod)this.DBGMods.get(i);
            if (dbg_mod.getNo() == modNo) {
                return dbg_mod.getName();
            }
            ++i;
        }
        return "";
    }

    private int getModByName(String modName) {
        int i = 0;
        while (i < this.DBGMods.size()) {
            PHPDBGMod dbg_mod = (PHPDBGMod)this.DBGMods.get(i);
            if (dbg_mod.getName().equalsIgnoreCase(modName)) {
                return dbg_mod.getNo();
            }
            ++i;
        }
        return -1;
    }

    private String getRawFrameData(char[] framesInfo, int frameNo) {
        int nextFrame = 0;
        int[] dbg_frame = new int[2];
        while (nextFrame < framesInfo.length) {
            dbg_frame[0] = PHPDBGBase.Char4ToInt(framesInfo, nextFrame);
            dbg_frame[1] = PHPDBGBase.Char4ToInt(framesInfo, nextFrame + 4);
            nextFrame += 8;
            if (dbg_frame[1] == 0) {
                return "";
            }
            switch (dbg_frame[0]) {
                case 100300: {
                    if (frameNo != PHPDBGBase.Char4ToInt(framesInfo, nextFrame)) break;
                    int toRead = PHPDBGBase.Char4ToInt(framesInfo, nextFrame + 4);
                    if (framesInfo[nextFrame + 8 + toRead - 1] == '\u0000') {
                        return String.copyValueOf(framesInfo, nextFrame + 8, toRead - 1);
                    }
                    return String.copyValueOf(framesInfo, nextFrame + 8, toRead);
                }
            }
            nextFrame += dbg_frame[1];
        }
        return "";
    }

    private void resetAvailability(Vector list) {
        int i = 0;
        while (i < list.size()) {
            ((PHPStackFrame)list.get(i)).setAvailable(false);
            ++i;
        }
    }

    private boolean isStackFrameInList(PHPStackFrame stackFrameNew, Vector list) {
        int i = 0;
        while (i < list.size()) {
            PHPStackFrame stackFrameOld = (PHPStackFrame)list.get(i);
            if (stackFrameNew.getDescription().equals(stackFrameOld.getDescription()) && stackFrameNew.getLineNumber() == stackFrameOld.getLineNumber()) {
                stackFrameOld.setAvailable(true);
                stackFrameOld.setIndex(stackFrameNew.getIndex());
                stackFrameOld.setScopeID(stackFrameNew.getScopeID());
                return true;
            }
            ++i;
        }
        return false;
    }

    private void markIdenticalStackFrames(Vector oldList, Vector newList) {
        this.resetAvailability(oldList);
        this.resetAvailability(newList);
        int i = 0;
        while (i < newList.size()) {
            PHPStackFrame stackFrameNew = (PHPStackFrame)newList.get(i);
            if (this.isStackFrameInList(stackFrameNew, oldList)) {
                stackFrameNew.setAvailable(true);
                break;
            }
            ++i;
        }
    }

    private void updateStackFrameList(Vector stackList) {
        PHPStackFrame stackFrameOld;
        int n;
        this.markIdenticalStackFrames(this.stackListOld, stackList);
        int i = 0;
        while (i < stackList.size()) {
            PHPStackFrame stackFrameNew = (PHPStackFrame)stackList.get(i);
            n = 0;
            while (n < this.stackListOld.size()) {
                stackFrameOld = (PHPStackFrame)this.stackListOld.get(n);
                if (!stackFrameOld.isAvailable() && stackFrameNew.getDescription().equals(stackFrameOld.getDescription())) {
                    stackFrameOld.setLineNumber(stackFrameNew.getLineNumber());
                    stackFrameOld.setIndex(stackFrameNew.getIndex());
                    stackFrameOld.setScopeID(stackFrameNew.getScopeID());
                    stackFrameOld.setAvailable(true);
                    stackFrameNew.setAvailable(true);
                    break;
                }
                ++n;
            }
            if (!stackFrameNew.isAvailable()) {
                stackFrameNew.setAvailable(true);
                this.stackListOld.add(stackFrameNew);
            }
            ++i;
        }
        n = 0;
        while (n < this.stackListOld.size()) {
            stackFrameOld = (PHPStackFrame)this.stackListOld.get(n);
            if (!stackFrameOld.isAvailable()) {
                this.stackListOld.remove(n--);
            }
            ++n;
        }
        Collections.sort(this.stackListOld);
        PHPStackFrame[] newStackList = new PHPStackFrame[this.stackListOld.size()];
        newStackList = this.stackListOld.toArray(newStackList);
        this.DBGStackList = newStackList;
    }

    public int readResponse() throws IOException {
        int bytesToRead = 0;
        int nextFrame = 0;
        int i = 0;
        int cmdReceived = 0;
        int stackIndex = 0;
        boolean errorStack = false;
        char[] dbg_header_struct_read = new char[16];
        int[] dbg_header_struct = new int[4];
        int[] dbg_bpl_tmp = new int[10];
        int[] dbg_frame = new int[2];
        int[] dbg_eval_tmp = new int[3];
        int[] dbg_src_tree_tmp = new int[4];
        int[] dbg_error_tmp = new int[2];
        Vector rawList = new Vector();
        Vector<PHPStackFrame> stackList = new Vector<PHPStackFrame>();
        rawList.clear();
        stackList.clear();
        while (this.readInput(dbg_header_struct_read, 16) != 0) {
            dbg_header_struct[0] = PHPDBGBase.Char4ToInt(dbg_header_struct_read, 0);
            dbg_header_struct[1] = PHPDBGBase.Char4ToInt(dbg_header_struct_read, 4);
            dbg_header_struct[2] = PHPDBGBase.Char4ToInt(dbg_header_struct_read, 8);
            dbg_header_struct[3] = PHPDBGBase.Char4ToInt(dbg_header_struct_read, 12);
            if (dbg_header_struct[0] != 22867) {
                return 0;
            }
            cmdReceived = dbg_header_struct[1];
            this.setLastCmd(cmdReceived);
            bytesToRead = dbg_header_struct[3];
            char[] entirePack = new char[bytesToRead];
            if (bytesToRead > 0 && this.readInput(entirePack, bytesToRead) < bytesToRead) {
                return 0;
            }
            nextFrame = 0;
            while (nextFrame < bytesToRead) {
                dbg_frame[0] = PHPDBGBase.Char4ToInt(entirePack, nextFrame);
                dbg_frame[1] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 4);
                nextFrame += 8;
                if (dbg_frame[1] == 0) {
                    return 0;
                }
                switch (dbg_frame[0]) {
                    case 100000: {
                        int[] dbg_stack_new = new int[]{PHPDBGBase.Char4ToInt(entirePack, nextFrame + 0), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 4), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 8), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 12)};
                        if (dbg_stack_new[1] != 0 && !errorStack) {
                            PHPStackFrame newStack = new PHPStackFrame(null, this.getModByNo(dbg_stack_new[1]), dbg_stack_new[0], ++stackIndex, this.getRawFrameData(entirePack, dbg_stack_new[3]), dbg_stack_new[1], dbg_stack_new[2]);
                            stackList.add(newStack);
                        }
                        errorStack = false;
                        break;
                    }
                    case 100100: {
                        break;
                    }
                    case 100200: {
                        dbg_src_tree_tmp[0] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 0);
                        dbg_src_tree_tmp[1] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 4);
                        dbg_src_tree_tmp[2] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 8);
                        dbg_src_tree_tmp[3] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 12);
                        if (!this.getModByNo(dbg_src_tree_tmp[2]).equals("")) break;
                        String fileName = new String(this.getRawFrameData(entirePack, dbg_src_tree_tmp[3]));
                        if (dbg_src_tree_tmp[2] == 0) break;
                        PHPDBGMod modNew = new PHPDBGMod(dbg_src_tree_tmp[2], fileName);
                        this.DBGMods.add(modNew);
                        break;
                    }
                    case 100300: {
                        break;
                    }
                    case 100400: {
                        errorStack = true;
                        dbg_error_tmp[0] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 0);
                        dbg_error_tmp[1] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 4);
                        String error = "\n";
                        switch (dbg_error_tmp[0]) {
                            case 1: {
                                error = String.valueOf(error) + "[Error]";
                                break;
                            }
                            case 2: {
                                error = String.valueOf(error) + "[Warning]";
                                break;
                            }
                            case 4: {
                                error = String.valueOf(error) + "[Parse Error]";
                                break;
                            }
                            case 8: {
                                error = String.valueOf(error) + "[Notice]";
                                break;
                            }
                            case 16: {
                                error = String.valueOf(error) + "[Core Error]";
                                break;
                            }
                            case 32: {
                                error = String.valueOf(error) + "[Core Warning]";
                                break;
                            }
                            case 64: {
                                error = String.valueOf(error) + "[Compile Error]";
                                break;
                            }
                            case 128: {
                                error = String.valueOf(error) + "[Compile Warning]";
                                break;
                            }
                            case 256: {
                                error = String.valueOf(error) + "[User Error]";
                                break;
                            }
                            case 512: {
                                error = String.valueOf(error) + "[User Warning]";
                                break;
                            }
                            case 1024: {
                                error = String.valueOf(error) + "[User Notice]";
                                break;
                            }
                            default: {
                                error = String.valueOf(error) + "[Unexpected Error]";
                            }
                        }
                        error = String.valueOf(error) + ": ";
                        error = String.valueOf(error) + new String(this.getRawFrameData(entirePack, dbg_error_tmp[1]));
                        error = String.valueOf(error) + "\n";
                        PHPDebugCorePlugin.log((Throwable)new DebugException((IStatus)new Status(2, "net.sourceforge.phpeclipse.debug.core", 0, error, null)));
                        if (this.stopOnError) break;
                        if (this.lastCommand.equals(PHPDBGBase.DBGA_CONTINUE)) {
                            this.continueExecution();
                            break;
                        }
                        if (this.lastCommand.equals(PHPDBGBase.DBGA_STEPINTO)) {
                            this.stepInto();
                            break;
                        }
                        if (this.lastCommand.equals(PHPDBGBase.DBGA_STEPOUT)) {
                            this.stepOut();
                            break;
                        }
                        if (!this.lastCommand.equals(PHPDBGBase.DBGA_STEPOVER)) break;
                        this.stepOver();
                        break;
                    }
                    case 100500: {
                        dbg_eval_tmp[0] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 0);
                        dbg_eval_tmp[1] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 4);
                        dbg_eval_tmp[2] = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 8);
                        this.evalRet = this.getRawFrameData(entirePack, dbg_eval_tmp[1]);
                        break;
                    }
                    case 100600: {
                        break;
                    }
                    case 100700: {
                        int[] dbg_bpl_new = new int[]{PHPDBGBase.Char4ToInt(entirePack, nextFrame + 0), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 4), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 8), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 12), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 16), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 20), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 24), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 28), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 32), PHPDBGBase.Char4ToInt(entirePack, nextFrame + 36)};
                        i = 0;
                        while (i < this.DBGBPList.size()) {
                            dbg_bpl_tmp = (int[])this.DBGBPList.get(i);
                            if (dbg_bpl_tmp[8] == dbg_bpl_new[8]) {
                                this.DBGBPList.remove(i);
                                break;
                            }
                            ++i;
                        }
                        this.DBGBPList.add(dbg_bpl_new);
                        this.copyToLastBP(dbg_bpl_new);
                        if (!this.getModByNo(dbg_bpl_new[0]).equals("")) break;
                        String fileName = new String(this.getRawFrameData(entirePack, dbg_bpl_new[2]));
                        if (dbg_bpl_new[0] == 0) break;
                        PHPDBGMod modNew = new PHPDBGMod(dbg_bpl_new[0], fileName);
                        this.DBGMods.add(modNew);
                        break;
                    }
                    case 100800: {
                        break;
                    }
                    case 100900: {
                        this.sid = PHPDBGBase.Char4ToInt(entirePack, nextFrame + 0);
                        break;
                    }
                    case 101000: {
                        break;
                    }
                    case 101100: {
                        break;
                    }
                    case 101200: {
                        break;
                    }
                    case 101300: {
                        break;
                    }
                    case 101400: {
                        break;
                    }
                }
                nextFrame += dbg_frame[1];
            }
            switch (cmdReceived) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.sessionEnded = true;
                    this.proxy.setTerminated();
                    break;
                }
                case 3: {
                    this.BPUnderHit = this.getBPUnderHit();
                    this.updateStackFrameList(stackList);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 19: {
                    this.BPUnderHit = 1;
                    this.updateStackFrameList(stackList);
                    break;
                }
                case 16: {
                    stackList.clear();
                    this.updateStackFrameList(stackList);
                    break;
                }
                case 17: {
                    break;
                }
            }
        }
        return cmdReceived;
    }

    public PHPStackFrame[] getStackList() {
        return this.DBGStackList;
    }

    private int readInput(char[] buffer, int bytes) throws IOException {
        int bytesRead = 0;
        int i = 0;
        while (i < bytes) {
            if (!this.in.ready()) break;
            buffer[i] = (char)(this.in.read() & 0xFF);
            ++bytesRead;
            ++i;
        }
        return bytesRead;
    }

    public void setShouldStop() {
        this.shouldStop = true;
    }

    public boolean waitResponse(long milliseconds) throws IOException {
        long timeout = System.currentTimeMillis() + milliseconds;
        while (System.currentTimeMillis() < timeout) {
            if (this.in.ready() || this.shouldStop) break;
        }
        return this.in.ready();
    }
}

