/* -*-c++-*- Present3D - Copyright (C) 1999-2006 Robert Osfield 
 *
 * This software is open source and may be redistributed and/or modified under  
 * the terms of the GNU General Public License (GPL) version 2.0.
 * The full license is in LICENSE.txt file included with this distribution,.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * include LICENSE.txt for more details.
*/

#ifndef OSG_COMPILESLIDECALLBACK
#define OSG_COMPILESLIDECALLBACK 1

#include <osgViewer/Viewer>

namespace ss3d {

class CompileSlideCallback : public osg::Camera::DrawCallback
{
    public:

        CompileSlideCallback():
            _needCompile(false),
            _frameNumber(0) {}

        virtual void operator()(const osg::Camera& camera) const;

        void needCompile(osg::Node* node) { _needCompile=true; _sceneToCompile = node; }

    protected:
    
        virtual ~CompileSlideCallback() {}
        
        mutable bool                _needCompile;
        mutable int                 _frameNumber;
        osg::ref_ptr<osg::Node>     _sceneToCompile;

};

}

#endif
