/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicControl;
import dk.borderworlds.MusicPlayer;
import dk.borderworlds.MusicQueue;
import dk.borderworlds.Song;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MusicStatus
implements ActionListener,
Runnable {
    private JPanel panel;
    private MusicQueue queue1;
    private MusicQueue queue2;
    private JButton play;
    private JButton stop;
    private JButton skip;
    private JTextField statusField;
    private JTextField fileField;
    private JTextField songField;
    private JTextField posField;
    private JTextField lengthField;
    private MusicPlayer[] players;
    private MusicPlayer player;
    private MusicControl mc;
    private Thread updater;
    private boolean skipping;
    private boolean stopWhenFinished;

    public MusicStatus(MusicQueue musicQueue, MusicQueue musicQueue2, MusicPlayer[] musicPlayerArray, MusicControl musicControl) {
        this.queue1 = musicQueue;
        this.queue2 = musicQueue2;
        this.players = musicPlayerArray;
        this.mc = musicControl;
        this.player = null;
        this.skipping = false;
        this.stopWhenFinished = false;
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JLabel("Play status"), "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel = new JLabel("Status:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusField = new JTextField("Stopped");
        this.statusField.setEditable(false);
        gridBagLayout.setConstraints(this.statusField, gridBagConstraints);
        jPanel.add(this.statusField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel2 = new JLabel("File:");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.fileField = new JTextField("(none)");
        this.fileField.setEditable(false);
        gridBagLayout.setConstraints(this.fileField, gridBagConstraints);
        jPanel.add(this.fileField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel3 = new JLabel("Song:");
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.songField = new JTextField("(none)");
        this.songField.setEditable(false);
        gridBagLayout.setConstraints(this.songField, gridBagConstraints);
        jPanel.add(this.songField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel4 = new JLabel("Position:  ");
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.posField = new JTextField("N/A");
        this.posField.setEditable(false);
        gridBagLayout.setConstraints(this.posField, gridBagConstraints);
        jPanel.add(this.posField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel5 = new JLabel("Length:");
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.lengthField = new JTextField("N/A");
        this.lengthField.setEditable(false);
        gridBagLayout.setConstraints(this.lengthField, gridBagConstraints);
        jPanel.add(this.lengthField);
        this.panel.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        this.play = new JButton("Play");
        this.play.addActionListener(this);
        this.stop = new JButton("Stop");
        this.stop.addActionListener(this);
        this.skip = new JButton("Skip");
        this.skip.addActionListener(this);
        jPanel2.add(this.play);
        jPanel2.add(this.stop);
        jPanel2.add(this.skip);
        this.panel.add((Component)jPanel2, "South");
        this.updater = new Thread(this);
        this.updater.start();
    }

    public Component getComponent() {
        return this.panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Play") || string.equals("Skip")) {
            this.playNext();
        } else if (string.equals("Pause")) {
            this.player.pauseSong();
            this.play.setText("Resume");
        } else if (string.equals("Resume")) {
            this.player.resumeSong();
            this.play.setText("Pause");
        } else if (string.equals("Stop") && this.player != null) {
            this.skipping = true;
            this.player.stopSong();
            this.player = null;
            this.play.setText("Play");
            this.skipping = false;
        }
    }

    public void stopPlaying() {
        if (this.player != null) {
            this.skipping = true;
            this.player.stopSong();
            this.player = null;
        }
        this.skipping = false;
    }

    public void stopAndRequeue() {
        Song song;
        if (this.player != null && (song = this.player.getSong()) != null) {
            this.queue1.addSong(song, true);
            this.stopPlaying();
            this.play.setText("Play");
        }
    }

    private void playNext() {
        Song song;
        if (this.player != null) {
            this.skipping = true;
            this.player.stopSong();
        }
        if ((song = this.queue1.getSong()) == null) {
            song = this.queue2.getSong();
        }
        if (song != null) {
            for (int i = 0; i < this.players.length; ++i) {
                if (!this.players[i].acceptsType(song.getType())) continue;
                this.player = this.players[i];
                i = this.players.length;
            }
            if (this.player != null) {
                this.player.playSong(song);
                this.play.setText("Pause");
            }
        } else {
            this.player = null;
            this.play.setText("Play");
        }
        this.skipping = false;
    }

    public void stopWhenFinished(boolean bl) {
        this.stopWhenFinished = bl;
    }

    public void run() {
        while (true) {
            String string = "MusicControl";
            if (this.player != null) {
                String string2 = this.player.getStatus();
                this.statusField.setText(string2);
                this.fileField.setText(this.player.getFilename());
                this.songField.setText(this.player.getTitle());
                this.posField.setText(this.player.getPosition());
                this.lengthField.setText(this.player.getLength());
                if (string2.equals("Stopped") && !this.skipping) {
                    this.player = null;
                    if (this.stopWhenFinished) {
                        this.play.setText("Play");
                        this.mc.musicStopped();
                    } else {
                        this.playNext();
                    }
                }
                if (!this.skipping && this.player != null) {
                    string = string + " - " + this.player.getTitle();
                }
            } else {
                this.statusField.setText("Stopped");
                this.songField.setText("(none)");
                MusicControl.mainFrame.setTitle("MusicControl");
            }
            MusicControl.mainFrame.setTitle(string);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }
}

