/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.ModPlayer;
import dk.borderworlds.Mp3Player;
import dk.borderworlds.MusicConfiguration;
import dk.borderworlds.MusicList;
import dk.borderworlds.MusicPlayer;
import dk.borderworlds.MusicQueue;
import dk.borderworlds.MusicStatus;
import dk.borderworlds.OggPlayer;
import dk.borderworlds.Song;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class MusicControl
implements ActionListener,
Runnable {
    protected static JFrame mainFrame;
    protected MusicPlayer[] players;
    private MusicQueue mq1;
    private MusicList ml;
    private Thread updater;
    private MusicStatus status;
    private MusicConfiguration configuration = new MusicConfiguration();
    private JCheckBoxMenuItem stopWhenFinishedItem;

    public MusicControl() {
        this.players = new MusicPlayer[3];
        this.players[0] = new OggPlayer(this.configuration);
        this.players[1] = new Mp3Player(this.configuration);
        this.players[2] = new ModPlayer(this.configuration);
    }

    public static void main(String[] stringArray) {
        MusicControl musicControl = new MusicControl();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-s")) {
                musicControl.setDevice("STDOUT");
                continue;
            }
            if (stringArray[i].equals("-h")) {
                System.err.println("Usage: musiccontrol [-s] dir1 dir2 ...");
                System.exit(0);
                continue;
            }
            vector.add(stringArray[i]);
        }
        String[] stringArray2 = new String[vector.size()];
        vector.toArray(stringArray2);
        musicControl.setupGUI(stringArray2);
    }

    protected void setDevice(String string) {
        this.configuration.setDevice("STDOUT");
    }

    protected void setupGUI(String[] stringArray) {
        mainFrame = new JFrame("MusicControl");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setOpaque(true);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Configuration...");
        jMenuItem.addActionListener(this.configuration);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Reload volumes");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Exit");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        JMenu jMenu2 = new JMenu("Controls");
        this.stopWhenFinishedItem = new JCheckBoxMenuItem("Stop when finished", false);
        this.stopWhenFinishedItem.addActionListener(this);
        jMenu2.add(this.stopWhenFinishedItem);
        jMenu2.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Stop and requeue");
        jMenuItem4.addActionListener(this);
        jMenu2.add(jMenuItem4);
        JMenu jMenu3 = new JMenu("Help");
        JMenuItem jMenuItem5 = new JMenuItem("About");
        jMenuItem5.addActionListener(this);
        jMenu3.add(jMenuItem5);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jMenu3);
        mainFrame.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        mainFrame.getContentPane().add(jSplitPane);
        this.mq1 = new MusicQueue("Random queue");
        Component component = this.mq1.getComponent();
        jPanel.add(component);
        MusicQueue musicQueue = new MusicQueue("Manual queue");
        Component component2 = musicQueue.getComponent();
        jPanel.add(component2);
        this.status = new MusicStatus(musicQueue, this.mq1, this.players, this);
        Component component3 = this.status.getComponent();
        jPanel.add(component3);
        this.ml = new MusicList(musicQueue, stringArray);
        this.configuration.setMusicList(this.ml);
        Component component4 = this.ml.getComponent();
        jPanel2.add(component4, "Center");
        this.updater = new Thread(this);
        this.updater.start();
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MusicControl.this.status.stopPlaying();
                System.exit(0);
            }
        });
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    public void musicStopped() {
        this.stopWhenFinishedItem.setSelected(false);
        this.status.stopWhenFinished(this.stopWhenFinishedItem.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Exit")) {
            this.status.stopPlaying();
            System.exit(0);
        } else if (string.equals("Reload volumes")) {
            this.ml.rescan();
        } else if (!string.equals("About")) {
            if (string.equals("Stop when finished")) {
                this.status.stopWhenFinished(this.stopWhenFinishedItem.isSelected());
            } else if (string.equals("Stop and requeue")) {
                this.status.stopAndRequeue();
            }
        }
    }

    public void run() {
        while (true) {
            for (int i = this.mq1.size(); i < 5; ++i) {
                Song song = this.ml.pickRandom();
                if (song == null) continue;
                this.mq1.addSong(song);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
            }
        }
    }
}

