/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicConfiguration;
import dk.borderworlds.MusicPipe;
import dk.borderworlds.MusicPlayer;
import dk.borderworlds.Song;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModPlayer
extends MusicPlayer
implements Runnable {
    private Song song = null;
    private Process proc = null;
    private BufferedInputStream bis;
    String name;
    private Thread inputreader;
    private String status;
    private String statusLine;
    private String title;
    private String filename;
    private int pausePosition;
    private MusicConfiguration configuration;
    private boolean paused;
    private MusicPipe pipe;

    public ModPlayer(MusicConfiguration musicConfiguration) {
        this.configuration = musicConfiguration;
        this.paused = false;
    }

    public void playSong(Song song) {
        this.song = song;
        this.playSong(0);
    }

    public void playSong(int n) {
        this.status = n == 0 ? "Starting" : "Resuming";
        this.title = this.song.getFilename();
        this.filename = this.song.getFilename();
        Runtime runtime = Runtime.getRuntime();
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.proc = null;
        }
        try {
            int n2;
            String string = this.configuration.getDevice();
            int n3 = n2 = this.pausePosition == 0 ? 2 : 4;
            if (string.equals("STDOUT")) {
                ++n2;
            }
            String[] stringArray = new String[n2];
            stringArray[0] = "simplemod";
            if (string.equals("STDOUT")) {
                stringArray[1] = "-r";
            }
            if (this.pausePosition != 0) {
                stringArray[n2 - 3] = "-k";
                stringArray[n2 - 2] = "" + this.pausePosition;
            }
            stringArray[n2 - 1] = this.song.getDirectory() + File.separator + this.song.getFilename();
            this.proc = runtime.exec(stringArray);
            InputStream inputStream = this.proc.getErrorStream();
            this.pipe = new MusicPipe(this.proc.getInputStream());
            this.bis = new BufferedInputStream(inputStream);
            this.inputreader = new Thread(this);
            this.inputreader.start();
            this.status = "Playing";
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void pauseSong() {
        Pattern pattern;
        Matcher matcher;
        this.pausePosition = this.statusLine != null ? ((matcher = (pattern = Pattern.compile(",(\\d+)$")).matcher(this.statusLine)).find() ? Integer.parseInt(matcher.group(1)) : 0) : 0;
        this.paused = true;
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            this.proc = null;
        }
    }

    public void resumeSong() {
        if (this.paused) {
            this.playSong(this.pausePosition);
            this.pausePosition = 0;
            this.paused = false;
        }
    }

    public void stopSong() {
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            this.proc = null;
            this.song = null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatus() {
        if (this.status.equals("Retrying")) {
            this.playSong(0);
            return "Retrying";
        }
        if (this.status.equals("Playing") && this.bis == null) {
            if (!this.paused) {
                this.status = "Stopped";
                this.song = null;
            } else {
                this.status = "Paused";
            }
        }
        return this.status;
    }

    public String getFilename() {
        if (this.song == null) {
            return "(none)";
        }
        return this.filename;
    }

    public String getTitle() {
        if (this.song == null) {
            return "(none)";
        }
        return this.title;
    }

    public String getPosition() {
        if (this.statusLine != null) {
            Pattern pattern = Pattern.compile("^\\s*(\\d+),");
            Matcher matcher = pattern.matcher(this.statusLine);
            if (matcher.find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = n / 60;
                return "" + n2 + ":" + ((n %= 60) < 10 ? "0" : "") + n;
            }
            return "N/A";
        }
        return "N/A";
    }

    public String getLength() {
        return "N/A";
    }

    public boolean acceptsType(String string) {
        return string.equals("stm") || string.equals("mod") || string.equals(".xm") || string.equals(".it") || string.equals("s3m");
    }

    public Song getSong() {
        return this.song;
    }

    public void run() {
        boolean bl = true;
        byte[] byArray = new byte[1024];
        this.statusLine = "";
        byte[] byArray2 = new byte[80];
        int n = 0;
        Pattern pattern = Pattern.compile("^Title: (.*)$");
        Pattern pattern2 = Pattern.compile("^P:(\\s*\\d+,\\d+)\\s");
        Pattern pattern3 = Pattern.compile("^Could not initialize sound");
        while (bl) {
            try {
                int n2 = this.bis.read(byArray, 0, 1024);
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        if (byArray[i] == 10 || byArray[i] == 13) {
                            String string = new String(byArray2, 0, n);
                            Matcher matcher = pattern2.matcher(string);
                            if (matcher.find()) {
                                this.statusLine = matcher.group(1);
                            }
                            if ((matcher = pattern.matcher(string)).matches()) {
                                this.title = matcher.group(1);
                            }
                            if ((matcher = pattern3.matcher(string)).find()) {
                                this.status = "Retrying";
                            }
                            n = 0;
                            continue;
                        }
                        byArray2[n++] = byArray[i];
                    }
                    continue;
                }
                if (n2 != -1) continue;
                this.bis.close();
                this.bis = null;
                bl = false;
            }
            catch (Exception exception) {
                this.bis = null;
                bl = false;
            }
        }
    }
}

