#include "SlideShow.h"
#include "global.h"
#include "Config.h"
#include "Jukebox.h"
#include "Loading.h"

static const int N=5;
static const int img_time=100;
static const real dm=15;
static const real dz=10000;

SlideShow::SlideShow() {
	const char files[][25]={
		"data/slides/01.png",
		"data/slides/02.png",
		"data/slides/03.png",
		"data/slides/04.png",
		"data/slides/05.png"
	};
	int is[N],iaux,ir;
	for (int i=0;i<N;i++) is[i]=i;
	for (int i=0;i<N-1;i++) {
		ir = i+rand()%(N-i);
		iaux=is[i]; is[i]=is[ir]; is[ir]=iaux;
	}
	for (int i=0;i<N;i++) {
		img[i].LoadFromFile(fix_image_file(files[is[i]]));
		spr[i].SetImage(img[i]);
		spr[i].SetCenter(img[i].GetWidth()/2,img[i].GetHeight()/2);
	}
	load_wh(c,fix_image_file(config->spanish?"data/misc/congrats_es.png":"data/misc/congrats.png"),1,1);
	csprite.SetPosition(screen_w/2,screen_h-ch/2);
	load_fade;
	if (config->music_on) {
		mmusic.OpenFromFile("data/music/guitar00.ogg");
		mmusic.SetLoop(false);
	}
}

void SlideShow::Run() {
	if (config->music_on) {
		music->StopMusic();
		mmusic.Play();
	}
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	tl=img_time; tt=75; ci=0; 
	cvx=real(rand()%21-10)/dm; cvy=real(rand()%21-10)/dm; cvz=real(rand()%21-10)/dz;
	cx=-cvx*((rand()%30)+30); cy=-cvy*((rand()%30)+30); cz=1.1-cvz*(rand()%20);
	Fade(true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->music_on) mmusic.Stop();
			last_key=sf::Key::Escape; Fade(false);
			App->Clear(Color(0,0,0,255));App->TimedDisplay();
			if (config->music_on) music->PlayMusic();
			return;
		} } else {
			last_key=sf::Key::Count;
		}
		Draw();
		App->TimedDisplay();
	}
}

void SlideShow::Draw() {
	App->Clear(Color(0,0,0,255));
	cx+=cvx; cy+=cvy; cz+=cvz;
	nx+=nvx; ny+=nvy; nz+=nvz;
	if (tl<0) {
		int a=((-tl)*255)/tt;
		spr[ci].SetColor(Color(255,255,255,255-a));
		spr[ci].SetPosition(cx+screen_w/2,cy+screen_h/2);
		spr[ci].SetScale(cz*global_scale,cz*global_scale);
		App->Draw(spr[ci]);
		spr[ni].SetColor(Color(255,255,255,a));
		spr[ni].SetPosition(nx+screen_w/2,ny+screen_h/2);
		spr[ni].SetScale(nz*global_scale,nz*global_scale);
		App->Draw(spr[ni]);
		if (tl-1==-tt) {
			cx=nx; cy=ny; cvx=nvx; cvy=nvy; cz=nz; cvz=nvz;
			ci=ni; tl=img_time;
		}
	} else {
		spr[ci].SetColor(Color(255,255,255,255));
		spr[ci].SetPosition(cx+screen_w/2,cy+screen_h/2);
		spr[ci].SetScale(cz*global_scale,cz*global_scale);
		App->Draw(spr[ci]);
		if (tl==0) {
			ni=(ci+1)%N;				
			nvx=real(rand()%21-10)/dm; nvy=real(rand()%21-10)/dm; nvz=real(rand()%21-10)/dz;
			nx=-nvx*((rand()%30)+30); ny=-nvy*((rand()%30)+30); nz=1.1-nvz*(rand()%20);
		}
	}
	tl--;
	App->Draw(csprite);
}

implement_fade(SlideShow);
