#include "RaceMenu.h"
#include "Data.h"
#include "MyFont.h"
#include "SelectionWheel.h"
#include <sstream>
#include "TextViewer.h"
#include "text.h"
#include "Loading.h"
#include "Circuito.h"
#include "Carrera.h"
#include "Moto.h"
#include "Confirm.h"
#include "RaceResults.h"
#include "BikeSelection.h"
#include "Profile.h"
#include "Config.h"
#include "ChampionshipData.h"
#include "Jukebox.h"
#include "Experience.h"
#include "HiddenDriver.h"
using namespace std;

#define init_item(key,text,x,y) items[key]=text; pos[key][0]=x; pos[key][1]=y; charsdone[key]=0; sel_level[key]=0; selected[key]=false;

static string int2str(int x) {
	stringstream s;
	s<<x;
	return s.str();
}

static char *time2str(real sec) {
	static char buf[15];
	if (sec<=0) {
		buf[0]='-'; buf[1]='-'; buf[2]=':'; buf[3]='-';
		buf[4]='-'; buf[5]='.'; buf[6]='-'; buf[7]='-';
		buf[8]='\0'; return buf;
	}
	char *b=buf;
	int m = int (sec/60);
	int s = int (sec)%60;
	int f = int(sec*100)%100;
	*(b++)=m/10+'0';*(b++)=m%10+'0';
	*(b++)=':';
	*(b++)=s/10+'0';*(b++)=s%10+'0';
	*(b++)='.';
	*(b++)=f/10+'0';*(b++)=f%10+'0';
	*(b++)=0;
	return buf;
}

bool RaceMenu::Run() {
	if (!circuito->IsOk()) return false;
	Fade(true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				Fade(false); return false;
			} 
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(false); return false;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Return)) { if (last_key!=sf::Key::Return) {
			last_key=sf::Key::Return; if (SelOk()) return finish_ok;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Up)) { if (last_key!=sf::Key::Up) {
			last_key=sf::Key::Up; SelMove(true);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Down)) { if (last_key!=sf::Key::Down) {
			last_key=sf::Key::Down; SelMove(false);
		} } else if (!App->GetInput().IsKeyDown(last_key)) {
			last_key=sf::Key::Count;
		}
		Draw();
		App->TimedDisplay();
	}
	return false;
}

RaceMenu::RaceMenu(int atrack, int alaps, int alevel) {
	
//	if (championship_data) profile->on_championship=true;
	
//	App->SetFramerateLimit(0);
	
	loading->Draw();
	
	finish_ok=false;
	
	laps=alaps; qualylaps_done=0;
	qualylaps_total = laps/5; if (qualylaps_total<3) qualylaps_total=3;
	
	circuito=new Circuito(atrack);
	if (rain_mode) {
		load_wh(w,fix_image_file("data/misc/wrain.png"),1,1);
	} else if (night_mode) {
		load_wh(w,fix_image_file("data/misc/wnight.png"),1,1);
	} else {
		load_wh(w,fix_image_file("data/misc/wsun.png"),1,1);
	}
	wsprite.SetPosition(710,510); wsprite.SetScale(.5,.5);
	
	itrack=atrack;
	track_name=data->tracks[itrack].name;
	load_fade;
	load_wh(b,fix_image_file("data/menu/raceback.png"),1,1);
	bsprite.SetPosition(screen_w/2,screen_h/2);
	load_wh(t,fix_image_file(data->tracks[itrack].dir+"thumbnail.png"),1,1);
	tsprite.SetPosition(ptx=594,pty=423); 
	tsprite.SetScale(pts=global_scale*.65,global_scale*.65);
	if (tw*pts>345)
		tsprite.SetScale(pts=345.f/tw,345.f/tw);
	
	int x1=150,x2=450,x3=500,y1=180,y2=95;
	
	init_item(mir_practice,config->spanish?"PRACTICA":"PRACTICE",x1,y1+0);
	init_item(mir_qualify,config->spanish?"CLASIFICACION":"QUALIFY",x1,y1+50);
	init_item(mir_race,config->spanish?"CARRERA":"RACE",x1,y1+100);
	init_item(mir_bike_setup,config->spanish?"CONF. MOTO":"BIKE SETUP",x1,y1+150);
	init_item(mir_view_track,config->spanish?"VER CIRCUITO":"VIEW TRACK",x1,y1+200);
	init_item(mir_help,config->spanish?"AYUDA":"HELP!",x1,y1+250);
	
	init_item(mir_bestlap,"Best Lap: --:--.--",x2,y2+0);
	init_item(mir_qualifypos,"Qualify Result:",x2,y2+50);
	init_item(mir_qualifypos_value,"15/15 (3 laps to go)",x3,y2+90);
	init_item(mir_next,"Next Stage: Practice",x2,y2+140);
	
	UpdateResults();
	
	for (int i=0;i<mir_count;i++) selected[i]=false;
	for (int i=0;i<mir_count;i++) charsdone[i]=0;
	selection=mir_practice; selected[selection]=true;
	tostart=10;
	InitRacers(level=alevel);
//	App->SetFramerateLimit(FPS);
}

void RaceMenu::InitRacers(int alevel) {
	if (championship_data) {
		racers=new Racer[data->bike_count];
		for (int i=0;i<data->bike_count;i++)
			if (championship_data->bikes[i].idx==profile->bike)
				racers[i].SetFromProfile(i);
			else
				racers[i].SetFromChampionship(i,alevel);
	} else {
		racers=new Racer[data->bike_count];
		for (int i=0;i<data->bike_count;i++)
			if (i==profile->bike)
				racers[i].SetFromProfile(i);
			else
				racers[i].SetRandom(i,alevel);
	}
	int i=0;
	for (i=0;i<data->bike_count;i++) racers[i].best_lap=-1;
	for (i=0;i<data->bike_count;i++) {
		if (!racers[i].controller) break;
	}
	if (i) { Racer aux=racers[0]; racers[0]=racers[i]; racers[i]=aux; }
}

RaceMenu::~RaceMenu() {
	delete [] racers; racers=NULL;
	if (circuito) delete circuito;
	circuito=NULL;
}

void RaceMenu::Draw() {
	
	App->Draw(bsprite);
	
	font->RenderSmall(100,60,.75,track_name.c_str());
	string esc=config->spanish?"Presione X para regresar al menu principal":"Press X to return to main menu"; esc[config->spanish?9:6]=27;
	font->RenderSmall(30,575,.35,esc.c_str());
	
	if (tostart) {
		tostart--;
	} else {
		for (int i=0;i<mir_count;i++) {
			if (selected[i]) {
				if (sel_level[i]<8) sel_level[i]+=1;
			} else {
				if (sel_level[i]>0) sel_level[i]-=1;
			}
			font->RenderPartial(pos[i][0]-sel_level[i],pos[i][1]+sel_level[i],.55+.025*sel_level[i],items[i],charsdone[i]/char_speed);
			if (charsdone[i]==char_speed*items[i].size()) continue; charsdone[i]++;
		}
	}
	
	App->Draw(tsprite);
	App->Draw(wsprite);
	
	sel_wheel->Draw(pos[selection][0],pos[selection][1]);
	
}

void RaceMenu::SimulateQualify() {
	bool sound=config->sound_on;
	config->sound_on=false;
	for (int i=0;i<data->bike_count;i++) racers[i].best_lap=-1;
	for (int i=1;i<data->bike_count;i++) {
		carrera = new Carrera(racers[i],qualylaps_total);
		racers[i].best_lap = carrera->SimulateQualify();
		delete carrera; carrera=NULL;
	}
	loading->Draw();
	config->sound_on=sound;
}

bool RaceMenu::SelOk() {
	if (config->sound_on) music->snd_selok.Play();
	if (selection==mir_practice) {
		Fade(false);
		loading->Draw();
//		App->SetFramerateLimit(0);
		SendPlayerUp(); racers[0].start_pos=1;
		carrera = new Carrera(50,1,true);
//		App->SetFramerateLimit(FPS);
		carrera->Race();
		delete carrera;
		UpdateResults();
		Fade(true);
	} else if (selection==mir_qualify) {
		Fade(false);
		if (qualylaps_done<qualylaps_total) {
			loading->Draw();
//			App->SetFramerateLimit(0);
			if (!qualylaps_done) SimulateQualify(); SendPlayerUp(); racers[0].start_pos=1;
			carrera = new Carrera(qualylaps_total-qualylaps_done,data->bike_count,true);
			carrera->Sort();
//			App->SetFramerateLimit(FPS);
			ShowQualifyTable();
			carrera->Race();
			qualylaps_done+=moto_target->lap;
			delete carrera;
			if (qualylaps_done>qualylaps_done) qualylaps_done=qualylaps_total;
			UpdateResults();
		}
		ShowQualifyTable();
		Fade(true);
	} else if (selection==mir_race) {
		Fade(false);
		loading->Draw();
//		App->SetFramerateLimit(0);
		if (!qualylaps_done) { 
			SimulateQualify(); racers[0].start_pos=data->bike_count;
			carrera = new Carrera(qualylaps_total-qualylaps_done,data->bike_count,true);
			carrera->Sort(); delete carrera;
		}
		SendPlayerUp();
		carrera = new Carrera(laps,data->bike_count,false);
//		App->SetFramerateLimit(FPS);
		bool done=carrera->Race();
		carrera->DeleteSomething();
		loading->Draw();
		if (done) {
			finish_ok=true;
			RaceResults *results = new RaceResults();
			results->Calculate(carrera);
			if (championship_data) championship_data->ProcessPositions(laps,level);
			results->Show();
			loading->Draw();
			SendPlayerUp();
			int pts = profile->UpdatePoints(itrack,level,results->GetPlayerPos());
			if (pts>0) {
				Experience e(ET_CREDITS);
				e.Run();
			}
			if (championship_data && championship_data->next_race==-1) { // si termina el campeonato...
//				// buscar donde quedo y cuantos puntos hizo
				championship_data->Finish();
			}
			delete results;
		} else {
			SendPlayerUp();
		}
		delete carrera;
		return true;
	} else if (selection==mir_help) {
		Fade(false);
		TextViewer *text_viewer = new TextViewer("data/menu/help.png",config->spanish?"Carrera":"Race Mode",config->spanish?text_es_help_race:text_en_help_race);
		text_viewer->Show(); delete text_viewer;
		Fade(true);
	} else if (selection==mir_bike_setup) {
		Fade(false);
		BikeSelection *bike_selection = new BikeSelection(false);
		bike_selection->Select(1);
		delete bike_selection;
		Fade(true);
	} else if (selection==mir_view_track) {
		Zoom();
	}
	return false;
}

void RaceMenu::SelMove(bool up) {
	if (config->sound_on) music->snd_selmove.Play();
	if (up) {
		if (selection==mir_practice || (selection==mir_qualify && qualylaps_done)) return;
		selected[selection--]=false;
		selected[selection]=true;
	} else {
		if (selection==mir_help) return;
		selected[selection++]=false;
		selected[selection]=true;
	}
}

void RaceMenu::Zoom() {
	real zoom=0;
	if (config->extra_fx) {
		while (zoom<=1) {
			zoom+=.1;
			Draw();
			tsprite.SetPosition(ptx*(1-zoom)+screen_w/2*zoom,pty*(1-zoom)+screen_h/2*zoom);
			tsprite.SetScale((1-zoom)*pts+1.4*zoom*global_scale,(1-zoom)*pts+1.4*zoom*global_scale);
			fsprite.SetColor(Color(255,255,255,int(zoom*218)));
			App->Draw(fsprite);
			App->Draw(tsprite);
			App->TimedDisplay();
		}
	} else zoom=1;
	bool done=false;
	while (!done) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				done=true;
			} 
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
			last_key=sf::Key::Escape; done=true;
		} else if(App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
			last_key=sf::Key::Return; done=true;
		} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
			last_key=sf::Key::Count;
		}
		Draw();
		tsprite.SetPosition(screen_w/2,screen_h/2);
		tsprite.SetScale(1.4*global_scale,1.4*global_scale);
		App->Draw(fsprite);
		App->Draw(tsprite);
		App->TimedDisplay();
	}
	if (config->extra_fx) {
		while (zoom>0) {
			Draw();
			tsprite.SetPosition(ptx*(1-zoom)+screen_w/2*zoom,pty*(1-zoom)+screen_h/2*zoom);
			tsprite.SetScale((1-zoom)*pts+1.4*zoom*global_scale,(1-zoom)*pts+1.4*zoom*global_scale);
			fsprite.SetColor(Color(255,255,255,int(zoom*218)));
			App->Draw(fsprite);
			App->Draw(tsprite);
			App->TimedDisplay();
			zoom-=.1;
		}
	}
	
}

void RaceMenu::ShowQualifyTable() {
	RaceResults *table = new RaceResults();
	table->Calculate();
	table->Show();
	delete table;
}

void RaceMenu::SendPlayerUp() {
	int i;
	for (i=0;i<data->bike_count;i++)
		if (!racers[i].controller) break;
	Racer me=racers[i];
	racers[i]=racers[0];
	racers[0]=me;
}

void RaceMenu::UpdateResults() {
	real best_time=-1;
	int pos=data->bike_count;
	if (racers) {
		for (int i=0;i<data->bike_count;i++)
			if (!racers[i].controller) {
				best_time=racers[i].best_lap;
				pos=racers[i].start_pos;
				break;
			}
	}
	string bl = config->spanish?"Mejor Vuelta: --:--.--":"Best Lap: --:--.--";
	if (best_time>0) bl = string(config->spanish?"Mejor Vuelta: ":"Best Lap: ")+time2str(best_time);
	if (bl!=items[mir_bestlap]) {
		items[mir_bestlap]=bl; 
		if (charsdone[mir_bestlap]>0) 
			charsdone[mir_bestlap]=9;
	}
	
	if (!qualylaps_done) pos=data->bike_count;
	string qres = int2str(pos)+"/"+int2str(data->bike_count)+" ("+int2str(qualylaps_total-qualylaps_done)+" laps to go)";
	if (qres!=items[mir_qualifypos_value]) {
		items[mir_qualifypos_value]=qres; 
		charsdone[mir_qualifypos_value]=15;
	}
	
	string next=config->spanish?"Siguiente: Practica":"Next stage: practice";
	if (qualylaps_done) next=config->spanish?"Siguiente: Clasificacion":"Next stage: qualify";
	if (qualylaps_total<=qualylaps_done) next=config->spanish?"Siguiente: Carrera":"Next stage: race";
	if (items[mir_next]!=next) { 
		items[mir_next]=next; 
		if (charsdone[mir_next]>0) 
			charsdone[mir_next]=11;
	}
}

implement_fade(RaceMenu)
	
