#include "Particulas.h"
#include "Moto.h"

ParticulaExp *humo, *tierra;
ParticulaFix *marca;
ParticulaRain *lluvia;
ParticulaMove *chispa;

ParticulaExp::ParticulaExp(string file, int amax) {
	last=false;
	max=amax;
	s=new real[max];
	x=new real[max];
	y=new real[max];
	n0=n1=0;
	fname=file;
	Reload();
}

void ParticulaExp::Reload() {
	load_wh(p,fix_image_file(fname),1,1);
}

ParticulaRain::ParticulaRain(string file, int amax) {
	max=amax;
	rnd=new int[(mmax=max*51)+2];
	fname=file;
	Reload();
}

void ParticulaRain::Resize(int amax) {
	delete [] rnd;
	max=amax;
	rnd=new int[(mmax=max*51)+1];
}

void ParticulaRain::Reset() {
	for (int i=0;i<mmax;i++)
		rnd[i]=rand();
	n=0;
}

void ParticulaRain::Reload() {
	load_wh(p,fix_image_file(fname),1,1);
	psprite.SetBlendMode(Blend::Add);
}

ParticulaMove::ParticulaMove(string file, int amax) {
	max=amax;
	s=new int[max];
	dx=new real[max];
	dy=new real[max];
	x=new real[max];
	y=new real[max];
	n0=n1=0;
	fname=file;
	Reload();
}

void ParticulaMove::Reload() {
	load_wh(p,fix_image_file(fname),1,1);
}

void ParticulaExp::New(real ax, real ay) {
	if ((last=!last)) return; 
	if (!max) return;
	ax+=rand()%20-10; ay+=rand()%20-10;
	x[n1]=ax; y[n1]=ay; s[n1]=.6;
	if (++n1==max) n1=0;
	if (n1==n0) if (++n0==max) n0=0;
}
void ParticulaMove::New(real ax, real ay, real av) {
	for (int i=0;i<5;i++) {
		if (!max) return;
		ax+=rand()%51-25; ay+=rand()%51-25;
		dx[n1]=rand()%int(av*10)/10; dy[n1]=rand()%int(av*10)/10;
		x[n1]=ax; y[n1]=ay; s[n1]=0;
		if (++n1==max) n1=0;
		if (n1==n0) if (++n0==max) n0=0;
	}
}
void ParticulaExp::Update() {
	if (!max) return;
	int i=n0;
	while (i!=n1) {
		psprite.SetPosition(x[i],y[i]);
		psprite.SetScale(s[i]*global_scale,s[i]*global_scale);
		mycolor.a=30*(7.1-s[i]);
		psprite.SetColor(mycolor);
		App->Draw(psprite);
		s[i]+=0.055;
		if (s[i]>7) { n0=i+1; if (n0==max) n0=0; }
		if (++i==max) i=0;
	}
}

void ParticulaRain::Update(int cam_x, int cam_y, real cam_z) {
	int mx=cam_x-cam_z*screen_w/2;
	int my=cam_y-cam_z*screen_h/2;
	int dx=screen_w*cam_z, dy=screen_h*cam_z;
	int x,y,tot=max;
	psprite.SetRotation(atan2(cam_x-ox,cam_y-oy)*180/M_PI);
	real s = ((cam_x-ox)*(cam_x-ox)+(cam_y-oy)*(cam_y-oy))/700;
	psprite.SetScale(1*global_scale*cam_z,(s+1)*global_scale*cam_z);
	psprite.SetColor(Color(255,255,255,225/(1+s/4)));
	for (int i=0;i<tot;i++) {
		x=mx+rnd[n]%(dx);
		y=my+rnd[n+1]%(dy);
		n=(n+2)%mmax;
		psprite.SetPosition(x,y);
		App->Draw(psprite);
	}
	ox=cam_x; oy=cam_y;
}


ParticulaFix::ParticulaFix(string file, int amax) {
	max=amax;
	a=new real[max];
	x=new real[max];
	y=new real[max];
	n0=n1=0;
	fname=file;
	Reload();
}
	
void ParticulaFix::Reload() {
	load_wh(p,fix_image_file(fname),1,1);
	psprite.SetCenter(pw/2,ph/4);
}

void ParticulaFix::New(real ax, real ay, real aa) {
	if (!max) return;
	if (nc==max) {
		int c=0;
		real x0=moto_target->x-screen_w-screen_w,x1=moto_target->x+screen_w+screen_w;
		real y0=moto_target->y-screen_h-screen_h,y1=moto_target->y+screen_h+screen_h;
		while (x[n1]>x0&&x[n1]<x1&&y[n1]>y0&&y[n1]<y1&&c<max) {
			c++; if (++n1==max) n1=0;
		}
//		if (c==max) cerr<<"CCCC!\n";
		n0=n1+1; if (n0==max) n0=0;
	} else nc++;
	x[n1]=ax; y[n1]=ay; a[n1]=-aa*180/M_PI;
	if (++n1==max) n1=0;
	if (n1==n0) if (++n0==max) n0=0;
}

void ParticulaFix::Update() {
	if (!max) return;
	if (nc==max) {
		for (int i=0;i<max;i++) {
			psprite.SetPosition(x[i],y[i]);
			psprite.SetRotation(a[i]);
			App->Draw(psprite);
		}
	} else {
		int i=n0;
		while (i!=n1) {
			psprite.SetPosition(x[i],y[i]);
			psprite.SetRotation(a[i]);
			App->Draw(psprite);
			if (++i==max) i=0;
		}
	}
}
void ParticulaMove::Update() {
	if (!max) return;
	int i=n0;
	while (i!=n1) {
		psprite.SetPosition(x[i],y[i]);
		x[i]+=dx[i]; y[i]+=dy[i];
		App->Draw(psprite);
		s[i]++; if (s[i]>20) { n0=i+1; if (n0==max) n0=0; }
		if (++i==max) i=0;
	}
	
}

ParticulaExp::~ParticulaExp() {
	delete []x;
	delete []y;
	delete []s;
}
ParticulaFix::~ParticulaFix() {
	delete []x;
	delete []y;
	delete []a;
}
ParticulaMove::~ParticulaMove() {
	delete []x;
	delete []y;
	delete []s;
	delete []dx;
	delete []dy;
}

void ParticulaExp::Resize(int amax) {
	delete []x; x=NULL;
	delete []y; y=NULL; 
	delete []s; s=NULL;
	if (!(max=amax)) return;
	x=new real[max];
	y=new real[max];
	s=new real[max];
}

void ParticulaFix::Resize(int amax) {
	delete []x; x=NULL;
	delete []y; y=NULL; 
	delete []a; a=NULL;
	if (!(max=amax)) return;
	x=new real[max];
	y=new real[max];
	a=new real[max];	
}

void ParticulaMove::Resize(int amax) {
	delete []x; x=NULL;
	delete []y; y=NULL; 
	delete []s; s=NULL;
	delete []dx; dx=NULL;
	delete []dy; dy=NULL;
	if (!(max=amax)) return;
	x=new real[max];
	y=new real[max];
	s=new int[max];	
	dx=new real[max];	
	dy=new real[max];	
}

void ParticulaFix::Reset() {
	n0=n1=nc=0;
	psprite.SetColor(mult_color);
}

void ParticulaExp::Reset() {
	n0=n1=0;
	psprite.SetColor(mycolor=mult_color);
}

void ParticulaMove::Reset() {
	n0=n1=0;
}
