#include "Moto.h"
#include "Jukebox.h"
#include "Circuito.h"
#include "RaceExtras.h"
#include "Particulas.h"
#include "Carrera.h"
#include "Data.h"
#include <iostream>
#include "global.h"
#include "Loading.h"
#include "Profile.h"
#include "Config.h"
#include "StyleOsd.h"
using namespace std;

#define audio_attenuation .25
#define audio_min_distance 100
#define audio_margin screen_w

#define first_iframe 9
#define last_iframe 14

Moto *motos[bike_max];
Moto *moto_target;

Moto::Moto(const Racer &racer) {
	
	CERR(this<<" Moto::Moto "<<racer.name);
	
	idx=racer.idx;
	
	if (night_mode) {
		sprite_l.SetImage(race_extras->light_image);
		sprite_l.SetCenter(
			race_extras->light_image.GetWidth()/2,
			race_extras->light_image.GetHeight()*1);
		sprite_l.SetScale(3*global_scale,global_scale*3);
		sprite_l.SetBlendMode(Blend::Add);
	} else if (rain_mode) {
		sprite_l.SetImage(race_extras->spray_image);
		sprite_l.SetCenter(
			race_extras->spray_image.GetWidth()/2,
			25/global_scale);
		sprite_l.SetScale(3*global_scale,global_scale*3);
//		sprite_l.FlipY(true);
		sprite_l.SetBlendMode(Blend::Add);
	} else {
		sprite_s.SetImage(race_extras->shadow_image);
		sprite_s.SetCenter(
			race_extras->shadow_image.GetWidth()/2,
			race_extras->shadow_image.GetHeight()/2-5/global_scale);
		sprite_s.SetScale(global_scale,global_scale);
	}
	
	pos_largada apos=circuito->PosLargada(racer.start_pos-1);
		
	pos_stab=0; new_pos=pos=last_pos=racer.start_pos; time_last_check=0; time_last_lap=-1; last_drawed_style=0;
	
	hitted=hit=false; ignore_time=0;
	snd_pasto_playing=snd_marca_playing=false;
	check_dist=50000; route_alpha=route_last_alpha=apos.r;
	
	snd_engine.SetBuffer(music->buffers[esnd_engine]);
	snd_engine.SetLoop(true); snd_engine_playing=false;
	snd_engine.SetVolume(vol_sound*150);
	snd_engine.SetAttenuation(audio_attenuation); snd_engine.SetMinDistance(audio_min_distance);
	snd_engine.SetRelativeToListener(false);
	snd_hit.SetBuffer(music->buffers[esnd_hit]);
	snd_hit.SetMinDistance(audio_min_distance); snd_hit.SetAttenuation(audio_attenuation);
	snd_hit.SetVolume(100*vol_sound);
	snd_crash.SetBuffer(music->buffers[esnd_crash]);
	snd_crash.SetMinDistance(audio_min_distance); snd_crash.SetAttenuation(audio_attenuation);
	snd_crash.SetVolume(100*vol_sound);
	
	name=racer.name;
	
	for (int j=0;j<100;j++) {
		times_last_partials[j]=0;
		times_avg_partials[j]=0;
	}
	
	lap=1; im_done=lap_done=false; check_next=0; fnum=lfnum=0; last_dodge=0;
	
	vangle=rangle=0;
	
	route_next=0; route_next_v2=1; num_op_close=0; first_target=true;
	target_x=apos.x+sin(apos.a)*1500;
	target_y=apos.y-cos(apos.a)*1500;
	
	controller=racer.controller;
	fbdown=0; last_inc=0; crash_fase=0;
	last_power=0; power_slide=false; accel_time=20;
	cayendo=0; crash=false;
	delta_power_slide=velocidad=inclinacion=accel=tiron=0;
	wheelie=0; drafting=0; draft_time=0;
	target_cam_x=x=apos.x; target_cam_y=y=apos.y; direccion=apos.a;
	target_cam_z=1; drx=dry=0;
//	max_vel=40; max_accel=.75; min_accel=.1; brake=.5, min_vel=2; prop_tiron=.05;
//	max_inclinacion=.12, min_inclinacion=.0075; roce=.15; vel_max_inclinacion=10; vel_min_inclinacion=25;
	max_vel=40; max_accel=.65; /*min_accel=.1;*/ brake=.45, min_vel=2; prop_tiron=.045;
//	max_inclinacion=.10, min_inclinacion=.0075; roce=.10; vel_max_inclinacion=10; vel_min_inclinacion=25;
	max_inclinacion=.09, min_inclinacion=.0055; roce=.10; vel_max_inclinacion=9; vel_min_inclinacion=20;
	
	// aplicar setup de la moto
	real factor_vel=1+0.020*racer.vel;
	max_vel*=factor_vel;
	real factor_tiron=1+0.025*racer.turn;
	if (rain_mode) factor_tiron*=.8;
	prop_tiron*=factor_tiron; vel_min_inclinacion*=(factor_tiron+1)/2; vel_max_inclinacion*=(factor_tiron+1)/2;
	real factor_accel=1+0.020*racer.accel;
	if (rain_mode) factor_accel*=.7;
	max_accel*=factor_accel;
	real factor_brake=1+0.025*racer.brake;
	if (rain_mode) factor_brake*=.7;
	brake*=factor_brake;
	limit_vel=max_vel;
	
	festejo=5*30; festejo_aux=0;
	
	image.LoadFromFile(fix_image_file(racer.dir+"01.png"));
	int wframes=9, hframes=2;
	frames = new IntRect[wframes*hframes];
	int w=image.GetWidth()/wframes, h=image.GetHeight()/hframes;
	for (int i=0;i<hframes;i++)
		for (int j=0;j<wframes;j++)
			frames[j+i*wframes]=IntRect(j*w,i*h,(j+1)*w,(i+1)*h);
	sprite.SetImage(image);
	sprite.SetColor(mult_color);
	dx=w/2; dy=127/global_scale; dr=125/global_scale;
	sprite.SetCenter(dx,dy/2);
	sprite.SetScale(global_scale,global_scale);
	
	image_c.LoadFromFile(fix_image_file(racer.dir+"04.png"));
	sprite_c.SetImage(image_c);
	sprite_c.SetCenter(image_c.GetWidth()/8,image_c.GetHeight()/2);
	sprite_c.SetScale(global_scale,global_scale);
	minicolor=sprite_c.GetPixel(33/global_scale,79/global_scale);
	minicolor.a=200;
	sprite_c.SetColor(mult_color);

	cur_gear=0;
	gears[0]=0;
	gears[1]=max_vel/16*5;
	gears[2]=max_vel/16*9;
	gears[3]=max_vel/16*12;
	gears[4]=max_vel/16*14;
	gears[5]=max_vel/16*15;
	gears[6]=max_vel/16*16;
		
	loading->Draw();
}

void Moto::Control() {
	// check for drafting effect
	real cos_dir=cos(direccion), sin_dir=sin(direccion);
	real draft_tx=x+sin_dir*200,draft_ty=y-cos_dir*200;
	real draft_dmin, draft_aux; int draft_imin=-1;
	if (/*this==moto_target && */!carrera->qualy_mode) {
		for (int i=0;i<carrera->num_racers;i++) {
			if (motos[i]==this) continue;
			Moto &mt=*motos[i];
			draft_aux=(draft_tx-mt.x)*(draft_tx-mt.x)+(draft_ty-mt.y)*(draft_ty-mt.y);
			if (draft_imin==-1 ||draft_aux<draft_dmin) {
				draft_dmin=draft_aux; draft_imin=i;
			}
		}
		Moto &draft_mt=*motos[draft_imin];
		real draft_osin=sin(draft_mt.direccion), draft_ocos=cos(draft_mt.direccion);
		real draft_p1 = draft_osin*(draft_mt.x-x)-draft_ocos*(draft_mt.y-y);
		real draft_p2 = draft_ocos*(draft_mt.x-x)+draft_osin*(draft_mt.y-y);
		
	//	sprite.SetPosition(x+draft_ocos*draft_p2,y+draft_osin*draft_p2); 
	//	App->Draw(sprite);
		draft_p1+=60;
		if (draft_p2<0) draft_p2=-draft_p2;
		if (draft_p1>0 && draft_p1<500 && 5*draft_p2<draft_p1) {
			drafting=draft_mt.velocidad*0.0035;
			draft_time++;
		} else {
			drafting=0;
			draft_time=0;
		}
	}
//				real ocos=cos(motos[i]->direccion+motos[i]->inclinacion*15);
//				real osin=sin(motos[i]->direccion+motos[i]->inclinacion*15);
//				real opy=motos[i]->y-ocos*motos[i]->velocidad*4;
//				real opx=motos[i]->x+osin*motos[i]->velocidad*4;
//				if (motos[i]->crash) { opx=motos[i]->c_xm; opy=motos[i]->c_ym; }
//				
//				real d21=(mpx1-opx)*(mpx1-opx)+(mpy1-opy)*(mpy1-opy);
//				
//				if (this==moto_target) {
//					motos[i]->sprite.SetPosition(opx,opy);
//					App->Draw(motos[i]->sprite);
//				}
//				
//				if (d21<ctol2) {
//					real dp=(mpx1-x)*(opx-mpx1)+(mpy1-y)*(opy-mpy1);
//					if (dp>0) { 
//						if (key_accel) key_accel=false; 
//						else if (dp>300) key_brake=true;
//						if (((mpx1-x)-(opx-x))*((mpy1-y)-(opy-y))>0) { 
//							key_right=true; key_left=false;
//						} else {
//							key_right=false; key_left=true;
//						}
//					}
//				}
//				
//				real d22=(mpx2-opx)*(mpx2-opx)+(mpy2-opy)*(mpy2-opy);
//					motos[i]->sprite.SetPosition(opx,opy);
//					App->Draw(motos[i]->sprite);
//				if (d22<ctol2) {
//					real dp=(mpx2-x)*(opx-mpx2)+(mpy2-y)*(opy-mpy2);
//					if (dp>0) { 
//						if (key_accel) key_accel=false; 
//						else if (dp>300) key_brake=true;
//						if (((mpx2-x)-(opx-x))*((mpy2-y)-(opy-y))>0) { 
//							key_right=true; key_left=false;
//						} else {
//							key_right=false; key_left=true;
//						}
//					}
//				}
//			}
//		}
	
	
	// check out controllers
	if (!carrera->started) {
		key_accel=key_brake=key_right=key_left=false;
		if (controller)
			key_fake_accel=rand()%2;
		else {
			key_fake_accel=App->GetInput().IsKeyDown(config->key_accel);
			if (!key_fake_accel && config->joystick) {
				if (config->joy_accel_ib)
					key_fake_accel=App->GetInput().IsJoystickButtonDown(config->joystick-1,config->joy_accel-1);
				else {
					if (config->joy_accel>0)
						key_fake_accel=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(config->joy_accel-1)))>50;
					else
						key_fake_accel=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(-config->joy_accel-1)))<-50;
				}
			}
		}
		return;
	}
	if (controller==0) {
		key_accel=App->GetInput().IsKeyDown(config->key_accel);
		key_brake=App->GetInput().IsKeyDown(config->key_brake);
		key_left=App->GetInput().IsKeyDown(config->key_left);
		key_right=App->GetInput().IsKeyDown(config->key_right);
		if (config->joystick) {
			if (!key_accel) {
				if (config->joy_accel_ib)
					key_accel=App->GetInput().IsJoystickButtonDown(config->joystick-1,config->joy_accel-1);
				else { 
					if (config->joy_accel>0)
						key_accel=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(config->joy_accel-1)))>25;
					else
						key_accel=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(-config->joy_accel-1)))<-25;
				}
			}
			if (!key_brake) {
				if (config->joy_brake_ib)
					key_brake=App->GetInput().IsJoystickButtonDown(config->joystick-1,config->joy_brake-1);
				else {
					if (config->joy_brake>0)
						key_brake=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(config->joy_brake-1)))>25;
					else
						key_brake=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(-config->joy_brake-1)))<-25;
				}
			}
			if (!key_right) {
				if (config->joy_right_ib)
					key_right=App->GetInput().IsJoystickButtonDown(config->joystick-1,config->joy_right-1);
				else {
					if (config->joy_right>0)
						key_right=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(config->joy_right-1)))>25;
					else
						key_right=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(-config->joy_right-1)))<-25;
				}
			}
			if (!key_left) {
				if (config->joy_left_ib)
					key_left=App->GetInput().IsJoystickButtonDown(config->joystick-1,config->joy_left-1);
				else {
					if (config->joy_left>0)
						key_left=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(config->joy_left-1)))>25;
					else
						key_left=(App->GetInput().GetJoystickAxis(config->joystick-1,(Joy::Axis)(-config->joy_left-1)))<-25;
				}
			}
		}		
	} else {
		
		key_accel=velocidad<vel_min_inclinacion;
		key_brake=key_right=key_left=false;
		
		real tx=target_x,ty=target_y; // proximo objetivo
		real tx_v2=target_x_v2,ty_v2=target_y_v2; // siguiente del proximo
		
//		real fy=-cos(direccion), fx=sin(direccion);

		// desde mi pos (x,y) al prox target (tx,ty) hay un vector de direccion dx,dy y mod dm
		real dx=tx-x, dy=ty-y;
		real dm=sqrt(dx*dx+dy*dy);
		dx/=dm; dy/=dm;
		
		// desde el prox target (tx,ty) al siguiente (tx_v2, ty_v2) hay un vector de direccion dx_v2,dy_v2 y mod dm_v2
		real dx_v2=tx_v2-tx, dy_v2=ty_v2-ty;
		real dm_v2=sqrt(dx_v2*dx_v2+dy_v2*dy_v2);
		dx_v2/=dm_v2; dy_v2/=dm_v2;
		
//		if (moto_target==this) 
//			cerr<<route_next<<"  "<<check_next<<"  "<<check_dist<<endl;
		
		
		
		int *cnx=circuito->checkpoints[route_next];
		real cp_d2,cp_a, my_check_dist;
		{
			float dx=cnx[0]-cnx[2];
			float dy=cnx[1]-cnx[3];
			float dmx=x-cnx[2];
			float dmy=y-cnx[3];
			float m2=dx*dx+dy*dy;
			float pe=(dmx*dx+dmy*dy)/(m2);
			float fx=cnx[2]+pe*dx;
			float fy=cnx[3]+pe*dy;
			float m1=(fx-cnx[2])*(fx-cnx[2])+(fy-cnx[3])*(fy-cnx[3]);
			cp_a=pe<0?-sqrt(m1/m2):sqrt(m1/m2);
			dx=cnx[0]*cp_a+(1-cp_a)*cnx[2];
			dy=cnx[1]*cp_a+(1-cp_a)*cnx[3];
			my_check_dist=cp_d2=(x-dx)*(x-dx)+(y-dy)*(y-dy);
		}
		
		if ((first_target && dm<300) || (!first_target && my_check_dist<350*350)) {
			first_target=false;
//			if (circuito->ai_route[++route_next][0]==0) route_next=0;
			if (circuito->checkpoints[++route_next][0]==0) route_next=0;
//			route_alpha=(circuito->checkpoints_alpha[route_next][0]*3+route_alpha+real(rand()%101)/100)/5;
			route_ideal_alpha=circuito->checkpoints_alpha[route_next][0];
//			target_x=route_alpha*circuito->checkpoints[route_next][0]+(1-route_alpha)*circuito->checkpoints[route_next][2];
//			target_y=route_alpha*circuito->checkpoints[route_next][1]+(1-route_alpha)*circuito->checkpoints[route_next][3];
			
			if (circuito->checkpoints[++route_next_v2][0]==0) route_next_v2=0;
			target_x_v2=route_alpha_v2*circuito->checkpoints[route_next_v2][0]+(1-route_alpha_v2)*circuito->checkpoints[route_next_v2][2];
			target_y_v2=route_alpha_v2*circuito->checkpoints[route_next_v2][1]+(1-route_alpha_v2)*circuito->checkpoints[route_next_v2][3];
			
		}
		if (!first_target) {
			route_alpha=(route_ideal_alpha+route_last_alpha*num_op_close)/(1+num_op_close);
			target_x=route_alpha*circuito->checkpoints[route_next][0]+(1-route_alpha)*circuito->checkpoints[route_next][2];
			target_y=route_alpha*circuito->checkpoints[route_next][1]+(1-route_alpha)*circuito->checkpoints[route_next][3];
		}
		
//		if (this==moto_target) {
//			cerr<<route_alpha<<endl;
//			humo->New(target_x,target_y);
//		}
		
		real m=dy*sin_dir+dx*cos_dir;
		
		// step_ang es el paso de inclinacion necesario para ir de target a target_v2
		real diff_ang_v2=acos(dx_v2*sin_dir-dy_v2*cos_dir);
		real step_ang_v2=diff_ang_v2/(dm_v2/velocidad);
		if (step_ang_v2<0) {step_ang_v2=-step_ang_v2;}
		
		
		
		// proyectar a donde vamos a parar de seguir doblando asi
		real s=velocidad?dm/velocidad:1000; // frames hasta el objetivo si le apuntamos bien
		real pdir=direccion;
//		if (velocidad<vel_min_inclinacion) 
//			pdir+=s*inclinacion;
//		else 
//			pdir+=s*inclinacion/3;
//		real py=-cos(pdir), px=sin(pdir);
//		tx=x+dm*px; ty=y+dm*py;
		
		// m respecto a esa proyeccion
//		dx=tx-x; dy=ty-y; dm=sqrt(dx*dx+dy*dy); dx/=dm; dy/=dm;
//		real mp=dy*fx-dx*fy;
		if (s>100) s=100; // para que en las rectas no se salga
		pdir+=(s*(inclinacion>0?inclinacion:-inclinacion)/limit_inclinacion)*inclinacion/6;
		real py=-cos(pdir), px=sin(pdir);
		real mp=py*dx-px*dy;
		
		
		// tratar de no salir del camino
		if (qp_rueda2&qp_track && !(circuito->QuePisa(x+dr*(sin_dir*2-cos_dir)/3,y+dr*(-cos_dir*2-sin_dir)/3)&qp_track)) { 
			key_right=true; key_left=false;
			key_accel=true;
		} else if (qp_rueda2&qp_track && !(circuito->QuePisa(x+dr*(sin_dir*2+cos_dir)/3,y+dr*(-cos_dir*2+sin_dir)/3)&qp_track)) { 
			key_left=true; key_right=false;
			key_accel=true;
		} else 
			{ // si va por el camino correcto, ver para donde esta el target
			if (mp>0.010) { 
				key_left=true;
				if (mp>.20 && velocidad>10) {
					key_accel=false;
					if (mp>.65 || inclinacion>2*max_inclinacion/3) key_brake=true;
				} else 
					key_accel=true;
			} else if (mp<-0.010) { key_right=true; 
				if (mp<-.20 && velocidad>10) {
					key_accel=false;
					if (mp<-.65 || -inclinacion>2*max_inclinacion/3) key_brake=true;
				} else 
					key_accel=true;
			} else {
				key_accel=true;
				m=0;
			}
			// si vamos a tener que doblar mucho para el target_v2, vamos frenando antes
			real adm_v2=real(dm)/8000;
			if (velocidad>10 && step_ang_v2/2>(max_inclinacion*adm_v2+limit_inclinacion/2*(1-adm_v2))) {
				key_accel=false;
				key_brake=true;
			}
			
		}
		
//		if (moto_target==this) {
//			if (key_accel) cerr<<"ACCEL"<<endl; else cerr<<"NO ACCEL"<<endl;
//			if (key_brake) cerr<<"BRAKE"<<endl;
//		}
		
//		if (m<mp/2) { key_left=true; m=mp/2-m; }
//		else if (m>mp/2) { key_right=true; m=m-mp/2; }
//		else m=0;
//		if (!key_accel && (key_left||key_right) && m>limit_inclinacion*5) key_brake=true; 
//		else if (cayendo<=0) key_accel=true;
		
		// ver que no salgamos mucho de la pista (mira 25 frames adelante)
		pdir=direccion+20*inclinacion/2;
		py=-cos(pdir), px=sin(pdir);
		tx=x+20*velocidad*px; ty=y+20*velocidad*py;
		if ((qp_rueda1&qp_rueda2&qp_track)&&velocidad>vel_min_inclinacion) {
			if (!(circuito->QuePisa(tx,ty)&qp_track)) { 
				key_accel=false; key_brake=true;
			}
		}
		
		// no salir a lo bestia del pasto
		if (cayendo>0) key_accel=false; 
		
		tx=(tx+x)/2; ty=(ty+y)/2;

		
//		real steps1=6, steps2=10;
//		real mcos=cos(direccion+inclinacion*15);
//		real msin=sin(direccion+inclinacion*15);
//		real mpy1=y-mcos*velocidad*steps1;
//		real mpx1=x+msin*velocidad*steps1;
//		real mpy2=y-mcos*velocidad*steps2;
//		real mpx2=x+msin*velocidad*steps2;
//		real ctol2=4*velocidad*4*velocidad;
//		if (this==moto_target) {
//			sprite.SetPosition(mpx1,mpy1);
//			App->Draw(sprite);
//			sprite.SetPosition(mpx2,mpy2);
//			App->Draw(sprite);
//		}
//		for (int i=0;i<carrera->num_racers;i++) {
//			if (motos[i]!=this) {
//				real ocos=cos(motos[i]->direccion+motos[i]->inclinacion*15);
//				real osin=sin(motos[i]->direccion+motos[i]->inclinacion*15);
//				real opy=motos[i]->y-ocos*motos[i]->velocidad*4;
//				real opx=motos[i]->x+osin*motos[i]->velocidad*4;
//				if (motos[i]->crash) { opx=motos[i]->c_xm; opy=motos[i]->c_ym; }
//				
//				real d21=(mpx1-opx)*(mpx1-opx)+(mpy1-opy)*(mpy1-opy);
//				
//				if (this==moto_target) {
//					motos[i]->sprite.SetPosition(opx,opy);
//					App->Draw(motos[i]->sprite);
//				}
//				
//				if (d21<ctol2) {
//					real dp=(mpx1-x)*(opx-mpx1)+(mpy1-y)*(opy-mpy1);
//					if (dp>0) { 
//						if (key_accel) key_accel=false; 
//						else if (dp>300) key_brake=true;
//						if (((mpx1-x)-(opx-x))*((mpy1-y)-(opy-y))>0) { 
//							key_right=true; key_left=false;
//						} else {
//							key_right=false; key_left=true;
//						}
//					}
//				}
//				
//				real d22=(mpx2-opx)*(mpx2-opx)+(mpy2-opy)*(mpy2-opy);
//					motos[i]->sprite.SetPosition(opx,opy);
//					App->Draw(motos[i]->sprite);
//				if (d22<ctol2) {
//					real dp=(mpx2-x)*(opx-mpx2)+(mpy2-y)*(opy-mpy2);
//					if (dp>0) { 
//						if (key_accel) key_accel=false; 
//						else if (dp>300) key_brake=true;
//						if (((mpx2-x)-(opx-x))*((mpy2-y)-(opy-y))>0) { 
//							key_right=true; key_left=false;
//						} else {
//							key_right=false; key_left=true;
//						}
//					}
//				}
//			}
//		}
		
//		// evitar chocar a otros de frente
////			sprite.SetPosition(tx,ty);
////			App->Draw(sprite);
//		
		real r,dt,dp,dv;
		int choq=0; real cx=0,cy=0; num_op_close=0;
		for (int i=0;i<carrera->num_racers;i++) {
			if (motos[i]!=this) {
				Moto &mt=*(motos[i]);
				
				if (mt.ignore_time) continue;
					
				dv=(velocidad-mt.velocidad);
				if (dv<0) continue;
				
				if (mt.crash) {
					dx=mt.c_xm-x; dy=mt.c_ym-y; // diff entre motos
				} else {
					dx=mt.x-x; dy=mt.y-y; // diff entre motos
				}
				r=dx*sin_dir-dy*cos_dir; // proyectada sobre mi direccion
				px=x+r*sin_dir; py=y-r*cos_dir; // pos de la proyeccion
				dt=r; 
				if (dt>-50 && dt<250 && dp>-300&& dt<300) num_op_close++;
				if (dt<0) continue;
				dp=sqrt((mt.x-px)*(mt.x-px)+(mt.y-py)*(mt.y-py)); // distancias tangentes y perpendiculares
				
				if (dp*dt/dv/dv<(drafting>0.03?80:50)) { 
					cx+=dx; cy+=dy; choq++;
				}
			}
		}
		if (choq==0) {
			if (last_dodge) {last_dodge=0; key_left=key_right=false;}
		} else {
			real pe = (cx*(cos_dir)+cy*sin_dir)/choq;
			if (pe>0 || last_dodge>0) {
				key_left=true; key_right=false; 
				if (velocidad>vel_min_inclinacion/2) key_brake=true;
				last_dodge=1;
			} else {
				key_left=false; key_right=true;
				if (velocidad>vel_min_inclinacion/2) key_brake=true;
				last_dodge=-1;
			}
		}
//		num_op_close=1000;
		// evitar chocar a otros de costado
		double drfy=-dr*cos_dir/3, drfx=dr*sin_dir/3;
		for (int i=0;i<carrera->num_racers;i++) {
			if (motos[i]!=this) {
				Moto &mt=*(motos[i]);
				
				if (mt.ignore_time) continue;
				

				if (mt.crash) {
					px=mt.c_xm; py=mt.c_ym; // diff entre motos
				} else {
					px=mt.x; py=mt.y; // diff entre motos
				}
				
				dx = px - x+drfy; dx=dx*dx;
				dy = py - y-drfx; dy=dy*dy;
				if (dx<2500&&dy<2500) {
//					sprite.SetPosition(x+dr*(fy)/3,y+dr*(-fx)/3);
//					sprite.FlipY(true); App->Draw(sprite); sprite.FlipY(false); 
					if (key_right) key_right=false; else key_left=true;
				}
				
				dx = px - x-drfy; dx=dx*dx;
				dy = py - y+drfx; dy=dy*dy;
				if (dx<2500&&dy<2500) {
//					sprite.SetPosition(x+dr*(-fy)/3,y+dr*(fx)/3);
//					sprite.FlipY(true); App->Draw(sprite); sprite.FlipY(false); 
					if (key_left) key_left=false; else key_right=true;
				}
				
			}
		}
		
		
		// no querer atravezar una pared
		if (key_left && circuito->QuePisa(x+drfy,y-drfx)&qp_wall) { key_left=false; key_right=true; }
		else if (key_right && circuito->QuePisa(x-drfy,y+drfx)&qp_wall) { key_right=false; key_left=true; }

		if (velocidad<min_vel/3) { key_accel=true; key_brake=false; } // evitar estancamientos en choques multiples
		
		accel_time=200; // nunca power_slide
	}
}

void Moto::Vuelta() {
	
//	real dx=circuito->checkpoints[check_next][0]-x, dy=circuito->checkpoints[check_next][1]-y;
	
	
	int *cnx=circuito->checkpoints[check_next];
	float *cna=circuito->checkpoints_alpha[check_next];
	
	real cp_d2,cp_a;
	{
		float dx=cnx[0]-cnx[2];
		float dy=cnx[1]-cnx[3];
		float dmx=x-cnx[2];
		float dmy=y-cnx[3];
		float m2=dx*dx+dy*dy;
		float pe=(dmx*dx+dmy*dy)/(m2);
		float fx=cnx[2]+pe*dx;
		float fy=cnx[3]+pe*dy;
		float m1=(fx-cnx[2])*(fx-cnx[2])+(fy-cnx[3])*(fy-cnx[3]);
		cp_a=pe<0?-sqrt(m1/m2):sqrt(m1/m2);
		dx=cnx[0]*cp_a+(1-cp_a)*cnx[2];
		dy=cnx[1]*cp_a+(1-cp_a)*cnx[3];
		check_dist=cp_d2=(x-dx)*(x-dx)+(y-dy)*(y-dy);
//		if (this==moto_target) {
//			cerr<<check_next<<endl;
//			sprite.SetPosition(dx,dy);
//			App->Draw(sprite);
//		}
	}
	
	
//	real dx,dy;
//	dx=circuito->checkpoints[check_next][0]-x, dy=circuito->checkpoints[check_next][1]-y;
//	int cd1=int(dx*dx+dy*dy);
//	dx=circuito->checkpoints[check_next][2]-x, dy=circuito->checkpoints[check_next][3]-y;
//	int cd2=int(dx*dx+dy*dy);
//	check_dist=cd1<cd2?cd1:cd2;
	
	if (cp_d2<100*100 && cp_a>cna[1] && cp_a<cna[2]) { // si paso un check cualquiera
//		route_last_alpha=route_alpha=cp_a; if (route_alpha<0) route_alpha=0; else if (route_alpha>1) route_alpha=1;
		route_last_alpha=cp_a; if (route_last_alpha<0.5) route_last_alpha=0.5; else if (route_last_alpha>.95) route_last_alpha=.95;
		real tnow=(carrera->timer-clock_total)*TIMER_CTE;
		times_avg_partials[check_next]+=tnow-time_last_check;
		time_last_check=tnow;
		check_next++;
		if (circuito->checkpoints[check_next][0]==0) {
			check_next++; lap_done=true;
		}
		
		{
		int *cnx=circuito->checkpoints[check_next];
		real cp_d2,cp_a;
			float dx=cnx[0]-cnx[2];
			float dy=cnx[1]-cnx[3];
			float dmx=x-cnx[2];
			float dmy=y-cnx[3];
			float m2=dx*dx+dy*dy;
			float pe=(dmx*dx+dmy*dy)/(m2);
			float fx=cnx[2]+pe*dx;
			float fy=cnx[3]+pe*dy;
			float m1=(fx-cnx[2])*(fx-cnx[2])+(fy-cnx[3])*(fy-cnx[3]);
			cp_a=pe<0?-sqrt(m1/m2):sqrt(m1/m2);
			dx=cnx[0]*cp_a+(1-cp_a)*cnx[2];
			dy=cnx[1]*cp_a+(1-cp_a)*cnx[3];
			check_dist=cp_d2=(x-dx)*(x-dx)+(y-dy)*(y-dy);
		}
		
		times_last_partials[check_next]=tnow;
								
	}
	
	if (lap_done && (qp_rueda1&qp_finishline)) { // si termino la vuelta
	
		real tnow=(carrera->timer-clock_total)*TIMER_CTE;
		times_avg_partials[check_next-1]+=tnow-time_last_check;
		time_last_check=tnow;
		
		time_last_lap=(carrera->timer-clock_lap)*TIMER_CTE;
		if (!controller && profile) { // comparar vuelta con records
			if (profile->temp_best_lap<0||profile->temp_best_lap>time_last_lap) {
				profile->temp_best_lap=time_last_lap;
				profile->SetRecord(circuito->id,time_last_lap);
				race_extras->ShowRecord(false);
			}
			if (circuito->best_lap<0 || circuito->best_lap>time_last_lap) {
				circuito->best_lap=time_last_lap;
				data->SetRecord(circuito->id,name,time_last_lap);
				race_extras->ShowRecord(true);
			}
		}
		lap++; lap_done=false; clock_lap=carrera->timer; check_next=0; times_last_partials[0]=(carrera->timer-clock_total)*TIMER_CTE;
		
		if (lap>carrera->laps && !carrera->won) { // first?
			carrera->won=true;
			race_extras->Won(name);
		}
		
		if (!controller) { 
			if (carrera->won) {// race is over
				carrera->player_done=true;
				race_extras->ShowFlag();
			} else if (lap==carrera->laps && !controller) // last lap?
				race_extras->ShowLast();
		}
		if (carrera->won) {
			time_total=(carrera->timer-clock_total)*TIMER_CTE;
			im_done=true;
			if (controller) {
				real ps = 1.75+real(rand()%50)/100;
				max_accel/=ps; max_vel/=ps; brake/=ps; prop_tiron/=ps;
				vel_max_inclinacion/=ps; vel_min_inclinacion/=ps; 
			}
		}
		
	}
	
}

void Moto::Update(bool draw) {
	
	bool draw_style=(draw && !im_done && !controller);
	int draw_style_id=0;
	real cos_dir=cos(direccion+delta_power_slide), sin_dir=sin(direccion+delta_power_slide);
	if (crash) { // si se callo y esta girando en el suelo...
		if (velocidad) { draw_style_id=1; last_drawed_style=0; }
		power_slide=(wheelie=false); drafting=0;
		rangle=rangle*.98;
		snd_engine.SetPitch(.3+rangle/35);
		velocidad=0;
		if (!crash_fase) sprite_c.FlipX(rand()%2);
		crash_fase++;
		power_slide=false; accel_time=25;
		if (draw) {
			if (night_mode) sprite_c.SetColor(circuito->Luz(c_xm,c_ym));
			int w=image_c.GetWidth()/4;
			int h=image_c.GetHeight();
			int qp=circuito->QuePisa(c_xm,c_ym);
			if ((qp&qp_grass) && c_vm>min_vel/2) tierra->New(c_xm+rand()%81-40,c_ym+rand()%81-40);
			else if ((qp&qp_leca) && c_vm>min_vel/2) humo->New(c_xm+rand()%81-40,c_ym+rand()%81-40);
			else if (c_vm>3 && !rain_mode) chispa->New(c_xm+rand()%50-25,c_ym+rand()%50-25,5);
			sprite_c.SetPosition(c_xm,c_ym);
			sprite_c.SetSubRect(IntRect(0,0,w,h));
			sprite_c.SetRotation(c_am);
			if (config->extra_fx) {
				if (!night_mode) {
					sprite_s.SetRotation(c_am);
					sprite_s.SetPosition(c_xm-4,c_ym+4);
					App->Draw(sprite_s);
				}
			}
			App->Draw(sprite_c);
			c_xm+=sin(c_dm)*c_vm;
			c_ym-=cos(c_dm)*c_vm;
			c_am+=(rand()%10-2)*c_vm/5;
			c_vm*=.96; if (c_vm<2) c_vm=0;
			
			qp=circuito->QuePisa(c_xp,c_yp);
			if ((qp&qp_grass) && c_vp>min_vel) tierra->New(c_xp+rand()%41-20,c_yp+rand()%41-20);
			else if ((qp&qp_leca) && c_vp>min_vel) humo->New(c_xp+rand()%41-20,c_yp+rand()%41-20);
			c_xp+=sin(c_dp)*c_vp;
			c_yp-=cos(c_dp)*c_vp;
			sprite_c.SetPosition(c_xp,c_yp);
			if (rand()%int(3*max_vel)<c_vp) fnum=fnum%3+1;
			sprite_c.SetSubRect(IntRect(fnum*w,0,(fnum+1)*w,h));
			sprite_c.SetRotation(c_ap);
			c_ap+=(rand()%10-2)*c_vp/4;
//			if (config->extra_fx) {
//				sprite_s.SetRotation(c_ap);
//				sprite_s.SetPosition(c_xp-3,c_yp+3);
//				App->Draw(sprite_c);
//			}
			App->Draw(sprite_c);
		}
		c_vp*=.97; if (c_vp>0 && c_vp<5) { c_vp=0; cayendo=45; }
		cayendo--;
		if (c_vp==0 && cayendo<0) {
			cayendo=0; crash=false; ignore_time=45;
			velocidad=inclinacion=accel=tiron=0;
		}
		target_cam_x=(c_xp+c_xm)/2; target_cam_y=(c_yp+c_ym)/2;
//		return;
	} else {
		
		Control();
		if (!im_done) Vuelta();
		
		dry=dr*cos_dir/2; drx=dr*sin_dir/2;
		
		// averiguar donde estan pisando las ruedas
		qp_rueda1=circuito->QuePisa(x+drx,y-dry);
		qp_rueda2=circuito->QuePisa(x-drx,y+dry);
		
		// colision con otras motos (verifico mi rueda delantera contra las dos de las otras)
		real dmx,dmy;
		if (!carrera->qualy_mode) {
			for (int i=0;i<carrera->num_racers;i++) {
				if (motos[i]->ignore_time) continue;
				if (motos[i]!=this) {
					Moto &mt=*(motos[i]);
					if (mt.crash) {
						dmx=mt.c_xm-x-drx; if (dmx<0) dmx=-dmx;
						dmy=mt.c_ym-y+dry; if (dmy<0) dmy=-dmy;
						if (dmx<70&&dmy<70) { 
							hit=true; mt.hitted=true;
							if (velocidad>vel_min_inclinacion) {
								cayendo=250;
							} else {
								direccion-=real(rand()%101-50)/100; 
								velocidad/=1.5;
							}
							mt.c_vm+=velocidad/5;
							if (!rain_mode) chispa->New(x+drx,y-dry,5);
						}
					} else {
						dmx=mt.x-mt.drx-x-drx; if (dmx<0) dmx=-dmx;
						dmy=mt.y+mt.dry-y+dry; if (dmy<0) dmy=-dmy;
						if (dmx<40&&dmy<40) { 
							hit=true; mt.hitted=true;
							real pe = drx*mt.dry-dry*mt.drx;
							if (pe>0) {
								if (pe*velocidad>1500*max_vel) { 
									x-=drx; y+=dry; cayendo=250;
									mt.cayendo=250;
								}
								direccion-=real(rand()%30)/100; 
								mt.direccion+=real(rand()%30)/100; 
							} else {
								if (pe*velocidad<-1500*max_vel) { 
									x-=drx; y+=dry; cayendo=250;
									mt.cayendo=250;
								}
								direccion+=real(rand()%30)/100; 
								mt.direccion-=real(rand()%30)/100; 
							}
							velocidad/=1.04;
							mt.c_vm+=velocidad/10;
							if (!rain_mode) chispa->New(x+drx,y-dry,5);
						}
						dmx=motos[i]->x+motos[i]->drx-x-drx; if (dmx<0) dmx=-dmx;
						dmy=motos[i]->y-motos[i]->dry-y+dry; if (dmy<0) dmy=-dmy;
						if (dmx<40&&dmy<40) { 
							hit=true; mt.hitted=true;
							real pe = drx*mt.dry-dry*mt.drx;
							if (pe>0) {
								if (pe*velocidad>1500*max_vel) { 
									x-=drx; y+=dry; cayendo=250;
									mt.cayendo=250;
								}
								direccion-=real(rand()%30)/100;
								mt.direccion+=real(rand()%30)/100;
							} else {
								if (pe*velocidad<-1500*max_vel) { 
									x-=drx; y+=dry; cayendo=250;
									mt.cayendo=250;
								}
								direccion+=real(rand()%30)/100; 
								mt.direccion-=real(rand()%30)/100; 
							}
							velocidad/=1.05;
		//					humo->New(x+drx,y-dry);
						}
					}
				}
			}
		}
		
		// colision con paredes (verifico mi rueda)
		if (qp_rueda1&qp_wall) {
			draw_style_id=2; last_drawed_style=0;
			hit=true;
			if (draw) {
				tierra->New((x+drx),(y-dry));
				tierra->New((x+drx),(y-dry));
				tierra->New((x+drx),(y-dry));
			}
			
			real a0=direccion, a1=direccion;
			real px0,py0,px1,py1;
			while (circuito->QuePisa(
				px0=(x+dr*sin(a1)/2),
				py0=(y-dr*cos(a1)/2))&qp_wall)
				a1+=0.01;
			while (circuito->QuePisa(
				px1=(x+dr*sin(a0)/2),
				py1=(y-dr*cos(a0)/2))&qp_wall)
				a0-=0.01;
			if (cayendo<50) velocidad=velocidad/2;
			real old_dir=direccion;
			if (a1-direccion<direccion-a0)
				direccion=a1+M_PI/10;
			else
				direccion=a0-M_PI/10;
			int delta = int(100*velocidad/vel_max_inclinacion*(old_dir-direccion)/(M_PI/3));
			if (delta<0) delta=-delta;
			cayendo+=delta;
		}
		
		if (key_accel) {
			if (velocidad<3) { delta_power_slide+=real(rand()%11-5)/100; }
			accel=(max_accel*(max_vel-velocidad)/*+min_accel*velocidad*/)/max_vel;
			if (!wheelie && !power_slide && last_power==2 && accel_time<5) {
				if (inclinacion*inclinacion<0.00001) 
					wheelie++; 
				else {
					power_slide=true;
					if (draw) { humo->New(x,y); humo->New(x,y); humo->New(x,y); }
				}
			} else { 
				accel_time=0;
				if (noaccel_time++<5) last_power=1; else last_power=0;
			}
			if (wheelie) { wheelie++; if (wheelie>20) wheelie=20; }
		} else {
			noaccel_time=0;
			if (power_slide) {
				power_slide=false;
				accel_time=25;
			}
			if (accel_time++>5) last_power=0; else if (last_power==1) last_power=2;
			if (wheelie) wheelie-=2;
		}
		if (wheelie && (cayendo || !((qp_rueda1|qp_rueda2)&(qp_track)))) {
			if (wheelie>10) wheelie=8; else wheelie=0;
		}
		// zangoloteo cunado no va por asfaltox	
		if (velocidad>2.5) {
			if ((qp_rueda1|qp_rueda2)&qp_leca) 
				delta_power_slide+=(rand()%5-2)*.015;
			else if ((qp_rueda1|qp_rueda2)&qp_grass)
				delta_power_slide+=(rand()%5-2)*.01;
		}
		
		if (power_slide) {
			if (noaccel_time>10) draw_style_id=5;
			if ((qp_rueda1|qp_rueda2)&(qp_leca|qp_grass)) {
				power_slide=false;
				last_power=0;
			}
			accel-=roce*inclinacion*15;
		} else if (velocidad>vel_max_inclinacion) accel-=roce*inclinacion*50;
		if(key_brake) {
			if (wheelie) {if (wheelie>3) wheelie-=5; else wheelie=0; }
			if (fbdown++>20 && velocidad>.2) { // bloqueo
				if (inclinacion>0 && delta_power_slide<.1) delta_power_slide+=.01;
				if (inclinacion<0 && delta_power_slide>-.1) delta_power_slide-=.01;
				else if (last_inc>0 && delta_power_slide<.1) delta_power_slide+=.01;
				else if (last_inc<0 && delta_power_slide>-.1) delta_power_slide-=.01;
			}
			accel=-brake;
		} else
			fbdown=0;
		if (!key_accel && !key_brake) {
			accel=-roce;
		}
		
		if (velocidad>min_vel/20) { // efecto de las superficies
			if (rain_mode) { // todo patina mas, todo deja marca, nada levanta tierra
				if (qp_rueda1&qp_grass) {
					accel/=1.65; // el pasto patina, no hay traccion
					marca->New(x+drx,y-dry,direccion); // marca de frenada en el pasto
				}
				if (qp_rueda2&qp_grass) {
					accel/=1.65; // el pasto patina, no hay traccion
					marca->New(x,y,direccion); // marca de acelerada en el pasto
				}
				if (qp_rueda1&qp_leca) {
					marca->New(x+drx,y-dry,direccion); // marca de frenada en el pasto
					accel-=max_accel/3.5;
				}
				if (qp_rueda2&qp_leca) {
					marca->New(x,y,direccion); // marca de acelerada en el pasto
					accel-=max_accel/2.5;
				}
			} else {
				if (qp_rueda1&qp_grass) {
					accel/=1.5; // el pasto patina, no hay traccion
					if (draw && (cayendo>5 || key_brake)) marca->New(x+drx,y-dry,direccion); // marca de frenada en el pasto
				}
				if (qp_rueda2&qp_grass) {
					accel/=1.5; // el pasto patina, no hay traccion
					if (draw && (cayendo>5 || key_accel) ) marca->New(x,y,direccion); // marca de acelerada en el pasto
				}
				if (qp_rueda1&qp_leca) {
					if (draw && rand()%3==0) humo->New(x+drx,y-dry); // polvo de la leca
					accel-=max_accel/3;
				}
				if (qp_rueda2&qp_leca) {
					if (draw && rand()%3==0) humo->New(x-drx,y+dry); // polvo de la leca
					accel-=max_accel/2;
				}
			}
		}
		
		if (max_vel<velocidad) limit_inclinacion=min_inclinacion;
		else limit_inclinacion=(max_inclinacion*(max_vel-velocidad)+min_inclinacion*velocidad)/max_vel;
		real aux_tiron = limit_inclinacion*prop_tiron;
		if (key_right)
			tiron=aux_tiron;
		else if (key_left)
			tiron=-aux_tiron;
		else {
			if (inclinacion>-aux_tiron && inclinacion<aux_tiron) {
				tiron=0;
				inclinacion=0;
			} else if (inclinacion>0) {
				tiron=-aux_tiron;
			} else {
				tiron=aux_tiron;
			}
		}
	//		if (power_slide && (inclinacion>limit_inclinacion|| inclinacion<-limit_inclinacion)) cayendo+=5;// power_slide muy cerrado=al suelo
		if (tiron*inclinacion<0) {
			if (power_slide)
				tiron=0;
			else
				tiron*=2;
		}
		
		inclinacion+=(key_accel&&!power_slide?tiron*.85:tiron);
		
		if (inclinacion>limit_inclinacion) inclinacion=limit_inclinacion;
		else if (inclinacion<-limit_inclinacion) inclinacion=-limit_inclinacion;
		if (velocidad<10) { // se ve feo que gire en el lugar
			if (inclinacion>limit_inclinacion*velocidad/10)
				inclinacion=limit_inclinacion*velocidad/10;
			else if (inclinacion<-limit_inclinacion*velocidad/10)
				inclinacion=-limit_inclinacion*velocidad/10;
		}
		
		if (!(qp_rueda1&qp_grass) && !(qp_rueda2&qp_grass) && !power_slide) {
			if (cayendo<15) 
				cayendo=0;
			else
				cayendo-=15;
		} else {
			if (velocidad>vel_min_inclinacion && (qp_rueda1&qp_grass) && (inclinacion>limit_inclinacion/2 || inclinacion<-limit_inclinacion/2)) cayendo+=2;
			else if (velocidad>vel_min_inclinacion/5 && (qp_rueda1&qp_grass) && (key_left||key_right) && key_accel) cayendo+=2;
			else cayendo-=1;
			if (velocidad>vel_min_inclinacion && (qp_rueda2&qp_grass) && (inclinacion>limit_inclinacion/2 || inclinacion<-limit_inclinacion/2)) cayendo+=2;
			else if (velocidad>vel_min_inclinacion/5 && (qp_rueda2&qp_grass) && (key_left||key_right) && key_brake) cayendo+=2;
			else cayendo-=1;
			if (cayendo<0) cayendo=0;
		}
		if (cayendo>50) { 
			crash_fase=0;
			crash=true; 
			c_ym=y;
			c_xm=x;
			c_xp=x+dr/2*sin_dir;
			c_yp=y-dr/2*cos_dir;
			c_dp=c_ap=direccion+real(rand()%10)/50-.1;
			c_dm=c_am=direccion+real(rand()%10)/50-.1;
			c_vp=c_vm=velocidad/1.5;
		}
		
		if (velocidad>0) direccion+=(power_slide?inclinacion*4:inclinacion);
		if (velocidad>limit_vel && accel>0) 
			velocidad-=roce;
		else
			velocidad+=accel;
		velocidad+=drafting;
		if (velocidad<0) velocidad=0;
		
//		cos_dir=cos(direccion);
//		sin_dir=sin(direccion);
		
		y-=cos_dir*velocidad;
		x+=sin_dir*velocidad;
		
		target_cam_x=x+sin_dir*velocidad/max_vel*screen_d; target_cam_y=y-cos_dir*velocidad/max_vel*screen_d;
		target_cam_z=1.1+3*velocidad/max_vel/2;
		
		sprite.SetPosition(x,y);
		
		real draw_inclinacion=inclinacion/limit_inclinacion;
		if (draw_inclinacion<0) draw_inclinacion=-draw_inclinacion;
		int i_inclinacion=int(draw_inclinacion*8);
		
		if (rain_mode && velocidad>vel_min_inclinacion/2) {
			if (delta_power_slide>0) cayendo+=delta_power_slide*125;
			else cayendo-=delta_power_slide*125;
		}
		
		// control del grafico que se muestra
		if (velocidad>min_vel && cayendo>35) { // si se esta por caer
			fnum=17;
			direccion+=real(rand()%10)/50-.1;
		} else if (velocidad>min_vel && cayendo>5) { // si se esta empezando a patinar
			if (i_inclinacion>4) fnum=16; else fnum=15;
			direccion+=real(rand()%10)/50-.1;
		} else if (velocidad<max_vel/10) {
			if (velocidad<max_vel/20)
				fnum=0;
			else
				fnum=1;
		} else {
			if (i_inclinacion==0 || i_inclinacion==1) {
				if (im_done && pos==1 && festejo && !key_accel && !key_brake && !key_left && !key_right) {
					if (festejo_aux) festejo_aux--;
					else {festejo_f=5+rand()%2; festejo_aux=rand()%3+1;}
					if (accel_time>15) fnum=festejo_f; festejo--;
				} else {
					if (accel>0) fnum=4;
					else if (accel<-roce)
						fnum=2;
					else fnum=3;
				}
	//		} else if (i_inclinacion==1) {
	//			fnum=5;
			} else {
				if (i_inclinacion>7) i_inclinacion=7;
				fnum=first_iframe+i_inclinacion-2;
	//		} else if (i_inclinacion==2) {
	//			fnum=first_iframe+i_inclinacion-2;
	//		} else if (i_inclinacion==3) {
	//			fnum=first_iframe+1;
	//		} else if (i_inclinacion==4) {
	//			fnum=first_iframe+2;
	//		} else if (i_inclinacion==5) {
	//			fnum=first_iframe+3;
	//		} else {
	//			fnum=first_iframe+4;
			}
		}
		
		if (wheelie) {
			inclinacion/=2;
			if (wheelie>15) draw_style_id=6;
		}
		if (inclinacion>0.01) {
			last_inc=1; 
		} else if (inclinacion<-0.01) {
			last_inc=-1;
		}
		
		if (draw && !rain_mode) {
			if (qp_rueda2&qp_track) {
				if (delta_power_slide!=0) marca->New(x-drx/2,y+dry/2,direccion);	
			} else {
				if (delta_power_slide*delta_power_slide>.015) marca->New(x-drx/2,y+dry/2,direccion);	
			}
		}
		
		
		if (wheelie) { if (wheelie>10) fnum=8; else fnum=7; }
		
		// trancisiones
		if (fnum>4&&fnum<9) { // hacia wheelie o festejo
			if (lfnum!=2&&(lfnum<5||lfnum>8)) fnum=2;
		} else if (fnum>last_iframe+1) { // hacia caida
			if (lfnum!=first_iframe+1 && lfnum<last_iframe+1) fnum=first_iframe+1;
		} else if (lfnum>last_iframe+1 && fnum<=first_iframe) { // desde caida
			fnum=first_iframe+1;
		} else { // desde weelie o festejo
			if (lfnum!=2&&(lfnum>4&&lfnum<9)) fnum=2;
		}
		
		lfnum=fnum;
		
	//	if (power_slide) fnum=14;
		
		sprite.SetSubRect(frames[fnum]);
		if (power_slide) {
			if (inclinacion>0 && delta_power_slide<.15) delta_power_slide+=.01;
			if (inclinacion<0 && delta_power_slide>-.15) delta_power_slide-=.01;
		} else {
			// uso delta_power_slide para inclinar la moto en la salida, como si patinara un poco
			if (velocidad>=.1) {
				if (!key_brake) { // para cuando bloquea
					real power_d=key_accel?0.005:.025; // para cuando sale harando
					if (delta_power_slide>power_d) delta_power_slide-=power_d;
					else if (delta_power_slide<-power_d) delta_power_slide+=power_d;
					else delta_power_slide=0;
				}
			} else if (delta_power_slide) { // que al bloquera y detenerse por completo no se enderece
				direccion+=2*delta_power_slide/3; delta_power_slide/=3;
			}
		}
		
		real ddir=-(direccion+delta_power_slide*2/3)*180/M_PI;
		if (rain_mode && config->particles_hi) {
			sprite_l.SetPosition(x/*-sin_dir*20*/,y/*+cos_dir*20*/);
			sprite_l.SetRotation(ddir);
			sprite_l.FlipX(rand()%2==0);
			float s=.01*(1+lluvia->rnd[lluvia->n=(lluvia->n+1)%lluvia->mmax]%50)+velocidad/max_vel*2;
			sprite_l.SetScale(s*global_scale,s*global_scale);
		} else if (night_mode) {
			if (wheelie) {
				if (wheelie>10)
					sprite_l.SetPosition(x-sin_dir*40,y+cos_dir*40);
				else
					sprite_l.SetPosition(x-sin_dir*20,y+cos_dir*20);
			} else if (i_inclinacion>1) {
				if (inclinacion<0)
					sprite_l.SetPosition(x+cos_dir*(-fnum+first_iframe-2)*4,y+sin_dir*(-fnum+first_iframe-2)*4);
				else
					sprite_l.SetPosition(x+cos_dir*(fnum-first_iframe+2)*4,y+sin_dir*(fnum-first_iframe+2)*4);
			} else
				sprite_l.SetPosition(x,y);
	//		sprite_l.SetPosition(x,y);
			sprite_l.SetRotation(ddir);
	//		App->Draw(sprite_l);
		}
		sprite.SetRotation(ddir);
		if (inclinacion*inclinacion>0.000001 || cayendo>0) sprite.FlipX(inclinacion<0);
		if (draw) {
			if (night_mode) sprite.SetColor(circuito->Luz(x,y));
			if (config->extra_fx && !night_mode) {
				if (fnum>13) fnum=13;
				if (fnum>=first_iframe) {
					if (inclinacion<0)
						sprite_s.SetPosition(x-7+cos_dir*(-fnum+first_iframe-1)*4,y+7+sin_dir*(-fnum+first_iframe-1)*4);
					else
						sprite_s.SetPosition(x-7+cos_dir*(fnum-first_iframe+1)*4,y+7+sin_dir*(fnum-first_iframe+1)*4);
				} else
					sprite_s.SetPosition(x-7,y+7);
				sprite_s.SetRotation(-(direccion+delta_power_slide)*180/M_PI);
				App->Draw(sprite_s);
			}
			if (rain_mode) App->Draw(sprite_l);
			if (ignore_time) {
				if (((ignore_time--)/2)%2) {
					App->Draw(sprite);
				}
			} else {
				App->Draw(sprite);
			}
		}
		
		if (crash) fnum=1;

		if (!carrera->started) {
			clock_total=carrera->timer;
			clock_lap=carrera->timer;
			if (key_fake_accel && rangle<max_vel) 
				rangle=(rangle*15+(max_vel-rangle))/15;
			else if (rangle>0)
				rangle=(rangle*15-brake*25)/15;
		} else {
			if (cur_gear<5 && gears[cur_gear+1]<velocidad) cur_gear++;
			else if (cur_gear && gears[cur_gear]-(gears[cur_gear]-gears[cur_gear-1])*.30>velocidad) cur_gear--;
			if (velocidad<.1 && key_accel && key_brake) // quemando neumaticos
					rangle=((1.25+10*delta_power_slide)*(85+max_vel)/3+rangle*9)/10;
			else if ( key_accel && (delta_power_slide<-.01||delta_power_slide>.01)) { // power_slide
				rangle=((1.1+real(rand()%100)/200)*(85+max_vel)/3+rangle*9)/10;
			} else if (cur_gear) // 2da en adelante
				rangle=(((velocidad-gears[cur_gear])/(gears[cur_gear+1]-gears[cur_gear])/2+.85)*(85+max_vel)/3+rangle*9)/10;
			else // primera
				rangle=((velocidad/gears[1]*1.3)*(85+max_vel)/3+rangle*9)/10;
	//			rangle=(velocidad/gears[1]/2+.2+rangle*9)/10;
			vangle=(velocidad+vangle*9)/10;
		}
		
		if (draw&&key_accel&&key_brake&&velocidad<0.01) humo->New(x-drx,y+dry);
		if (config->sound_on) DoSound();
	}
	if (!carrera->qualy_mode && draw_style) {
		int sb;
		for (int i=0;i<carrera->num_racers;i++) {
			if (motos[i]==this) continue;
			Moto &mt=*motos[i];
			sb = mt.pos>pos?+1:-1;
			if (mt.last_pos!=sb) {
				if (mt.new_pos!=sb) {
					mt.pos_stab=0;
					mt.new_pos=sb;
				} else if (++mt.pos_stab>10) {
					if (carrera->started) style_osd->Add(sb<0?2:3,mt.x,mt.y-80,sin_dir*velocidad*.9,-cos_dir*velocidad*.9);
					mt.last_pos=sb;
				}
			} else mt.pos_stab=0;
		}
	}
	
	if (draft_time>15 && drafting>.02) draw_style_id=7;
	else if (velocidad>max_vel-roce) { wheelie=0; draw_style_id=8; }
	if (hit||hitted) { draw_style_id=2; last_drawed_style/=2; hitted=false; hit=false; }
	if (last_drawed_style) last_drawed_style--;
	else if (draw_style && draw_style_id) {
		style_osd->Add(draw_style_id-1,x,y-100,sin_dir*velocidad*.85,-cos_dir*velocidad*.85);
		last_drawed_style=15;
	}

	
}

void Moto::DoSound() {
//	if (this!=moto_target) return;
	real dx=x-moto_target->x, dy=y-moto_target->y;
//	if (dx<0) dx=-dx; if (dy<0) dy=-dy;
	if (dx<-audio_margin||dx>audio_margin||dy>audio_margin||dy<-audio_margin) {
		if (snd_engine_playing) {
			snd_engine.Stop();
			snd_engine_playing=false;
		}
		hit=false;
		return;
	}
	snd_engine.SetPitch(.5+rangle/45);
	if (hit) {
		snd_hit.SetPosition(dx,dy,0);
		snd_hit.Play();
		hit=false;
	}
	if (crash) {
		snd_crash.SetPosition(dx,dy,0);
		snd_crash.Play();
	}
	snd_engine.SetPosition(dx,dy,0);
	if (!snd_engine_playing) {
		snd_engine.Play();
		snd_engine_playing=true;
	}
	if (moto_target==this) {
		if ((qp_rueda1|qp_rueda2)&(qp_leca|qp_grass)&&!crash&&velocidad>.1) {
			if (!snd_pasto_playing) {
				music->snd_pasto.Play();
				snd_pasto_playing=true;
			}
			if (snd_marca_playing) {
				music->snd_marca.Pause();
				snd_marca_playing=false;
			}
		} else {
			if (snd_pasto_playing) {
				music->snd_pasto.Pause();
				snd_pasto_playing=false;
			}
			if (delta_power_slide && !crash && velocidad>.1) {
				if (!snd_marca_playing) {
					music->snd_marca.Play();
					snd_marca_playing=true;
				}
			} else {
				if (snd_marca_playing) {
					music->snd_marca.Pause();
					snd_marca_playing=false;
				}
			}
		}
	}
}

void Moto::Mute() {
	if (snd_engine_playing) snd_engine.Stop();
	if (snd_marca_playing) music->snd_marca.Stop();
	if (snd_pasto_playing) music->snd_pasto.Stop();
}

Moto::~Moto() {
	CERR(this<<" Moto::~Moto "<<name);
	delete [] frames;
	if (snd_engine_playing) snd_engine.Stop();
	if (snd_marca_playing) music->snd_marca.Stop();
	if (snd_pasto_playing) music->snd_pasto.Stop();
}

